/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.CList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class TraceLogUI implements SelectionListener, ModifyListener {

	private CList _list;
	private Button _delete;
	private Button _addAgent;
	private Label _newAgentLabel;
	private Text _newAgent;

	public TraceLogUI() {
		super();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/06/2000 3:38:47 PM)
	 */
	protected void addAgent() {
		String agentName = _newAgent.getText().trim();

		addAgent(agentName);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (4/30/2001 12:21:38 PM)
	 * @param name java.lang.String
	 */
	public void addAgent(String name) {
		_list.add(name);
		_list.getList().setSelection(_list.getList().indexOf(name));

		_newAgent.setText("");
		_newAgent.setFocus();

		_addAgent.setEnabled(false);
		_delete.setEnabled(true);
	}
	public Composite createControl(Composite parent) {
		GridLayout layout;
		GridData gd;

		Composite _result = new Composite(parent, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 2;
		_result.setLayout(layout);
		_result.setLayoutData(GridUtil.createFill());

		_list = new CList(_result, "");

		Composite buttons = new Composite(_result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 3;
		buttons.setLayout(layout);
		gd = new GridData();
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessVerticalSpace = true;
		gd.widthHint = 120;
		buttons.setLayoutData(gd);

		_delete = new Button(buttons, SWT.PUSH | SWT.NULL);
		_delete.setText(UIPlugin.getResourceString("REMOVE_AGENT"));
		_delete.setLayoutData(GridUtil.createHorizontalFill());
		Composite space = new Composite(buttons, SWT.NULL);
		space.setLayout(layout);
		space.setLayoutData(GridUtil.createFill());

		Composite addAgent = new Composite(_result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 3;
		addAgent.setLayout(layout);
		addAgent.setLayoutData(GridUtil.createHorizontalFill());

		_newAgentLabel = new Label(addAgent, SWT.NULL);
		_newAgentLabel.setText(UIPlugin.getResourceString("ADD_AGENT"));
		_newAgent = new Text(addAgent, SWT.BORDER);
		_newAgent.setLayoutData(GridUtil.createHorizontalFill());

		Composite addButton = new Composite(_result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 1;
		addButton.setLayout(layout);
		gd = new GridData();
		gd.widthHint = 120;
		addButton.setLayoutData(gd);

		_addAgent = new Button(addButton, SWT.PUSH);
		_addAgent.setText(UIPlugin.getResourceString("ADD_AGENT_BUTTON"));
		_addAgent.setLayoutData(GridUtil.createHorizontalFill());

		_addAgent.setEnabled(false);
		_delete.setEnabled(false);

		_delete.addSelectionListener(this);
		_addAgent.addSelectionListener(this);
		_newAgent.addModifyListener(this);

		/*_newAgent.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				if (key.character == 13)
					addAgent();
			}
		});*/

		_newAgent.addTraverseListener(new TraverseListener() {
			public void keyTraversed(TraverseEvent e) {
				if (e.detail == SWT.TRAVERSE_RETURN) {
					addAgent();
					e.doit = false;
				}
			}
		});

		_list.getList().addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				_delete.setEnabled(_list.getSelectedIndices().length > 0);
			}
		});

		_newAgent.setFocus();

		return _result;
	}
	public String[] getAgents() {
		return _list.getList().getItems();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:51:52 PM)
	 * @param event com.ibm.swt.events.ModifyEvent
	 */
	public void modifyText(ModifyEvent event) {
		if (event.widget == _newAgent)
			_addAgent.setEnabled(!_newAgent.getText().trim().equals(""));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/06/2000 3:52:27 PM)
	 */
	protected void removeAgent() {
		int selection = _list.getSelectedIndex();
		_list.remove(selection);

		if (_list.getItemCount() > 0) {
			if (selection == 0)
				_list.setSelectedIndex(0);
			if (selection < _list.getItemCount())
				_list.setSelectedIndex(selection);
			else if ((selection - 1) < _list.getItemCount())
				_list.setSelectedIndex(selection - 1);
			else
				_list.setSelectedIndex(0);
		} else
			_delete.setEnabled(false);

		_newAgent.setFocus();
		_newAgent.selectAll();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (4/30/2001 12:22:33 PM)
	 */
	public void reset() {
		_list.getList().removeAll();
		_delete.setEnabled(false);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:49:33 PM)
	 * @param event com.ibm.swt.events.SelectionEvent
	 */
	public void widgetDefaultSelected(SelectionEvent event) {
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:49:33 PM)
	 * @param event com.ibm.swt.events.SelectionEvent
	 */
	public void widgetSelected(SelectionEvent event) {
		if (event.widget == _addAgent)
			addAgent();
		else if (event.widget == _delete)
			removeAgent();
	}
}