/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID tvpp0001 for show Monitors checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0002 for show Hosts checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0003 for show Processes checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0004 for show Profiling Agents checkbox Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0005 for show JVM RAS Agents checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0006 for show Logging Agents checkbox in Monitor views preference page
*/

public class TraceViewOptionsUI
{
private NavigatorFilterSet[] _filterSets;
private Button[] _checkBoxes;
	
/**
 * TraceOptionsUI constructor comment.
 */
public TraceViewOptionsUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	
	Group content = new Group(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createHorizontalFill());
	content.setText(UIPlugin.getResourceString("STR_PREF_HIDE_GRP"));

	_filterSets = NavigatorExtensionUtil.getFilterSetElements(PDProjectExplorer.ID);
	_checkBoxes = new Button[_filterSets.length];
	for (int i=0;i<_filterSets.length;++i) {
		_checkBoxes[i] = new Button(content, SWT.CHECK);
		_checkBoxes[i].setText(_filterSets[i].getLabel());
	}

	initializeValues();
/*
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showMonitor,
		UIPlugin.getPluginId()+".tvpp0001");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showNode,
		UIPlugin.getPluginId()+".tvpp0002");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showProcess,
		UIPlugin.getPluginId()+".tvpp0003");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showProf,
		UIPlugin.getPluginId()+".tvpp0004");

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_showLog,
			UIPlugin.getPluginId()+".tvpp0006");
*/		
	return content; 
}
/**
 * Initializes states of the controls from the preference store.
 */
public void initializeValues()
{
	for (int i=0;i<_filterSets.length;++i) {
		_checkBoxes[i].setSelection(_filterSets[i].isEnabled());
	}
}

/**
 * Initializes the filter checkboxes to their defaults.
 */
public void initializeDefaults()
{
	for (int i=0;i<_filterSets.length;++i) {
		_checkBoxes[i].setSelection(_filterSets[i].isDefaultEnabled());
	}
}

/**
 * Store the current values to the preference store.
 */
public void storeValues()
{
	for (int i=0;i<_checkBoxes.length;++i) {
		_filterSets[i].setEnabled(_checkBoxes[i].getSelection());
	}
}
}
