/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.resource.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.part.*;

/*
* CONTEXT_ID node0000 for Node Editor
*/

public class TRCNodeEditor extends EditorPart {
	private TRCNode fNode;

	public TRCNodeEditor() {
		super();
	}
	public void createPartControl(Composite parent) {
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".node0000");

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		content.setLayout(layout);
		GridData gd = new GridData();
		gd.verticalAlignment = GridData.FILL;
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.widthHint = 500;
		content.setLayoutData(gd);

		TraceLocationUI locationUI = new TraceLocationUI();
		locationUI.createControl(content);
		locationUI.setEnabled(false);

		TraceNodeUI nodeUI = new TraceNodeUI();
		nodeUI.createControl(content);
		nodeUI.setEnabled(false);

		if (fNode != null) {
			TRCMonitor fMonitor = fNode.getMonitor();

			IPath path =
				new Path(TString.resourcePath(fMonitor.eResource().getURI()));
			locationUI.getLocation().setText(
				path.uptoSegment(path.segmentCount() - 1).toOSString());
			locationUI.getMonitor().setText(fMonitor.getName());

			nodeUI.getNodeNameUI().setText(fNode.getName());
			if (fNode.getIpAddress() != null)
				nodeUI.getAddressUI().setText(fNode.getIpAddress());

			if (fNode.getDeltaTime() != 0)
				nodeUI.setDeltaTime(fNode.getDeltaTime());
		}

	}
	/**
	 * Saves the contents of this editor.
	 * <p>
	 * If the save is successful, the editor fires a property changed event 
	 * reflecting the new dirty state (<code>PROP_SAVE_NEEDED</code> property).
	 * </p>
	 * <p>
	 * This method is long-running; progress and cancellation are provided
	 * by the given progress monitor. 
	 * </p>
	 *
	 * @param monitor the progress monitor
	 */
	public void doSave(IProgressMonitor monitor) {
	}
	/**
	 * Saves the contents of this editor to another object.
	 * <p>
	 * Implementors are expected to open a "save as" dialog where the user will
	 * be able to select a new name for the contents. After the selection is made,
	 * the contents should be saved to that new name.  During this operation a
	 * <code>ProgressMonitorDialog</code> should be used to indicate progress.
	 * </p>
	 * <p>
	 * If the save is successful, the editor fires a property changed event 
	 * reflecting the new dirty state (<code>PROP_SAVE_NEEDED</code> property).
	 * </p>
	 */
	public void doSaveAs() {
	}
	/**
	 * Returns the input for this editor.  If this value changes the part must 
	 * fire a property listener event with <code>PROP_INPUT</code>.
	 *
	 * @return the editor input
	 */
	//public IEditorInput getEditorInput();
	/**
	 * Returns the site for this editor. The method is equivalent to 
	 * <code>(IEditorSite) getSite()</code>.
	 *
	 * @return the editor site
	 */
	//public IEditorSite getEditorSite();
	/**
	 * Sets the cursor and selection state for this editor to the passage defined
	 * by the given marker.
	 *
	 * @param marker the marker
	 */
	public void gotoMarker(IMarker marker) {
	}
	/**
	 * Initializes this editor with the given editor site and input.
	 * <p>
	 * This method is automatically called shortly after part construction; it marks
	 * the start of the part's lifecycle. The 
	 * {@link IWorkbenchPart#dispose IWorkbenchPart.dispose} method will be called 
	 * automically at the end of the lifecycle. Clients must not call this method.
	 * </p><p>
	 * Implementors of this method must examine the editor input object type to
	 * determine if it is understood.  If not, the implementor must throw
	 * a <code>PartInitException</code>
	 * </p>
	 * @param site the editor site
	 * @param input the editor input
	 * @exception PartInitException if this editor was not initialized successfully
	 */
	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {
		if (input instanceof IFileEditorInput) {
			setSite(site);
			setInput(input);
			loadNodeDoc();

			if (fNode != null)
				setTitle(fNode.getName());
			else
				setTitle("UnknownNode");
		}
	}
	/**
	 * Returns whether the contents of this editor have changed since the last save
	 * operation.  If this value changes the part must fire a property listener 
	 * event with <code>PROP_DIRTY</code>.
	 * <p>
	 *
	 * @return <code>true</code> if the contents have been modified and need
	 *   saving, and <code>false</code> if they have not changed since the last
	 *   save
	 */
	public boolean isDirty() {
		return false;
	}
	/**
	 * Returns whether the "save as" operation is supported by this editor.
	 *
	 * @return <code>true</code> if "save as" is supported, and <code>false</code>
	 *  if "save as" is not supported
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}
	/**
	 * Returns whether the contents of this editor should be saved when the editor
	 * is closed.
	 *
	 * @return <code>true</code> if the contents of the editor should be saved on
	 *   close, and <code>false</code> if the contents are expendable
	 */
	public boolean isSaveOnCloseNeeded() {
		return false;
	}
	/**
	 * Returns the monitor.
	 */
	private TRCNode loadNodeDoc() {
		if (fNode == null) {
			try {
				String name =
					((FileEditorInput) getEditorInput())
						.getFile()
						.getFullPath()
						.toString();

				ResourceSet resourceSet =
					UIPlugin.getDefault().getResourceSet();
				Resource res =
					resourceSet.getResource(
						URI.createURI("platform:/resource" + name),
						true);

				if (res == null)
					return fNode;

				Iterator it = res.getContents().iterator();
				while (it.hasNext()) {
					Object current = it.next();
					if (current instanceof TRCNode) {
						fNode = (TRCNode) current;
						break;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return fNode;
	}
	/**
	 * Asks this part to take focus within the workbench.
	 * <p>
	 * Clients should not call this method (the workbench calls this method at
	 * appropriate times).
	 * </p>
	 */
	public void setFocus() {

	}
}
