/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class ProfileAgentsTab extends AbstractLaunchConfigurationTab
{
	private ILaunchConfiguration _conf;
	private DoubleCTree _list;

	public void createControl(Composite parent)
	{
		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_list = new DoubleCTree(content, SWT.NULL, UIPlugin.getResourceString("STR_LIST_AGENTS"), UIPlugin.getResourceString("STR_LIST_SOURCE"), UIPlugin.getResourceString("STR_LIST_TARGET"));
		_list.addListener(new Listener()
		{
			public void handleEvent(Event event)
			{
				// the list changed; update
				updateLaunchConfigurationDialog();
			}
		});

		Button refresh = new Button(content, SWT.PUSH);
		refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
		refresh.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
		refresh.addSelectionListener(new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				_list.initialize(new Vector(ProfileAttachDelegate.getNodeConfiguration(_conf)).elements(), false);
			}
		});

		WorkbenchHelp.setHelp(_list.getControl(), UIPlugin.getPluginId() + ".atlp0002");
		WorkbenchHelp.setHelp(refresh, UIPlugin.getPluginId() + ".atlp0000");
		WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".atlp0002");
	}

	public boolean isValid(ILaunchConfiguration conf)
	{
		setErrorMessage(null);
		setMessage(null);

		if (_list.getSelectedAgents().size() == 0)
		{
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
			return false;
		}

		return true;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		_conf = conf;
		
		BusyIndicator.showWhile(getShell().getDisplay(), new Runnable() {
			public void run()
			{
				List nodes = ProfileAttachDelegate.getNodeConfiguration(_conf);
				List agents = ProfileAttachDelegate.getAgents(_conf, nodes);
				if (agents.size() == 0) _list.removeAll();
				_list.initialize(new Vector(nodes).elements(), false);
				_list.setSelectedAgents(new Vector(agents));
			}
		});
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		List list = new ArrayList();
		Vector v = _list.getTargetItems();

		for (int i = 0; i < v.size(); ++i)
		{
			StringBuffer buf = new StringBuffer();

			try
			{
				/*
				 * A String of the form:
				 *   "pid:agent1Name,agent2Name,..."
				 */
				TreeItem processItem = (TreeItem)v.get(i);
				Process process = (Process)processItem.getData();
				buf.append(process.getProcessId());
				buf.append(':');

				TreeItem[] agentItems = processItem.getItems();
				for (int j = 0; j < agentItems.length; ++j)
				{
					Agent agent = (Agent)agentItems[j].getData();
					buf.append(agent.getName());

					// agent delimiter
					if (j < agentItems.length)
						buf.append(',');
				}
			}
			catch (InactiveProcessException e)
			{
				// print and continue
				e.printStackTrace();
			}

			list.add(buf.toString());
		}

		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, list);
	}

	public String getName()
	{
		return UIPlugin.getResourceString("TAB_NAME_AGENTS");
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_AGENT);
	}

	void reset()
	{
		_list.removeAll();
	}
}
