/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * @author znensi
 */
public class ProfileAttachDelegate implements ILaunchConfigurationDelegate
{
	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.beginTask("", 4);
			boolean success = ProfileJavaApplicationDelegate.performProfilingTypesLaunch(conf);
			monitor.worked(1);
			
			if (!success) {
				monitor.setCanceled(true);
				return;
			}

			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
			
			String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
			String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
			String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
			String profileFile = null;
			if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				profileFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
				
			ProfilingSetsManager manager = ProfilingSetsManager.instance();
			ArrayList filters = manager.getFilters(conf);
			Vector options = manager.getOptions(conf);
			Vector agents = new Vector(getAgents(conf));
			monitor.worked(1);
			
			/*
			 * #59138: Check if the agents listed in the launch config
			 * are still valid. If not, display an error message.
			 */
			List agentList = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
	
			// count the agents
			int agentCount = 0;
			if (agentList != null) {
				Iterator iter = agentList.iterator();
				while (iter.hasNext()) {
					String agentString = (String)iter.next();
					agentCount += new StringTokenizer(agentString, ":,").countTokens() - 1;
				}
			}
			
			if (agentCount != agents.size()) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						Shell parent = UIPlugin.getActiveWorkbenchShell();
						IStatus status = new Status(Status.WARNING, UIPlugin.getPluginId(), IResourceStatus.WARNING, UIPlugin.getResourceString("ERROR_DLG_INVALID_AGENTS_REASON"), null);
						ErrorDialog.openError(parent, UIPlugin.getResourceString("TRACE_MSG"), UIPlugin.getResourceString("LAUNCH_ERROR_"), status);
					}
				});
				monitor.setCanceled(true);
				return;
			}
			monitor.worked(1);
			
			PDCoreUtil.attach(hostName, agents, options, filters, projectName, monitorName,String.valueOf(port), profileFile);
			
			Display.getDefault().asyncExec(new Runnable() {
	        	public void run() {
	        		try{
	        			if (UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROFILE_TIPS)) {
	        				AttachWarningDialog infodialog = new AttachWarningDialog(null, UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
	        				infodialog.open();
	        			}
	        		} catch (Exception exc) {
	        			exc.printStackTrace();
	        		}
	        	}
	        });
			monitor.worked(1);
		}
		catch (CoreException e) {
			monitor.setCanceled(true);
			throw e;
		}
	}
	
	static List getNodeConfiguration(ILaunchConfiguration conf)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		try
		{
			String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt(HyadesConstants.LOCALHOST_PORT));
			Enumeration enum = PDCoreUtil.getNodeConfiguration(host, port); 
			List list = new ArrayList();
			if (enum != null)
			{
				while (enum.hasMoreElements())
					list.add(enum.nextElement());
			}
			//if the enum is null, an empty list will be returned
			return list;
		}
		catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public static List getAgents(ILaunchConfiguration conf) {
		return getAgents(conf, getNodeConfiguration(conf));
	}
	
	static List getAgents(ILaunchConfiguration conf, List nodes)
	{
		List agents = new ArrayList();

		if (nodes != null) {
			try
			{
				Iterator iter = nodes.iterator();
				List list = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
				if (list != null)
				{
					Map map = createMap(list);
	
					Vector v = new Vector();
					while (iter.hasNext())
					{
						Process process = (Process)iter.next();
						String[] selected = (String[])map.get(process.getProcessId());
						if (selected != null)
						{
							for (int i = 0; i < selected.length; ++i)
								agents.add(process.getAgent(selected[i]));
						}
					}
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}

		return agents;
	}

	// parse and organize the agents in a more accessible data structure
	private static Map createMap(List list)
	{
		Map map = new HashMap();

		Iterator iter = list.iterator();
		while (iter.hasNext())
		{
			StringTokenizer tok = new StringTokenizer((String)iter.next(), ":");
			String pid = tok.nextToken();

			tok = new StringTokenizer(tok.nextToken(), ",");
			String[] agents = new String[tok.countTokens()];

			for (int i = 0; i < agents.length; ++i)
				agents[i] = tok.nextToken();
			map.put(pid, agents);
		}

		return map;
	}
}

