/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.Iterator;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.PageBook;

/**
 * @author znensi
 */
public class ProfileOverviewTab {
	
	private TraceProfileOverviewUI _overviewUI;
	private PageBook _book;
	private Composite _ui;
	private Composite _blank;
	
	public ProfileOverviewTab(ProfileTab pt) {
		_overviewUI = new TraceProfileOverviewUI();
	}
	
	public Composite createControl(Composite parent) {
		_book = new PageBook(parent, SWT.NONE);
		_ui = _overviewUI.createControl(_book);

		DefaultPage page = new DefaultPage();
		page.setMessage(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
		page.createControl(_book);
		_blank = (Composite)page.getControl();
	
		return _book;
	}
	
	public void addListener(Listener _listener) {
		_overviewUI.addListener(_listener);
	}
	
	public void initializeFrom(ILaunchConfiguration conf) {
		if (optionsAllowed(conf)) {
			_overviewUI.initializeFrom(conf);
			_book.showPage(_ui);
		}
		else {
			_book.showPage(_blank);
		}
	}
	   
	public void performApply(ILaunchConfigurationWorkingCopy wc) {
		_overviewUI.performApply(wc);
	}
	
	public boolean isValid(ILaunchConfiguration conf) {
		return _overviewUI.isValid(conf);
	}

	/*
	 * Returns true iff we are attaching to one or more profiling agents
	 * or zero J2EE request agents. When this is false, the UI options do
	 * not get used and so the UI will be disabled.
	 */
	private static boolean optionsAllowed(ILaunchConfiguration conf) {
		boolean hasJ2EEAgent = false;
		boolean hasNonJ2EEAgent = false;
		Iterator i = ProfileAttachDelegate.getAgents(conf).iterator();
		while (i.hasNext()) {
			Agent agent = (Agent)i.next();
	        if (agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
	            if (agent.getName().equals(TraceConstants.J2EE_AGENT_NAME)) {
	            	hasJ2EEAgent = true;
	            }
	            else {
	            	hasNonJ2EEAgent = true;
	            }
	        }
		}
				
		return (hasNonJ2EEAgent || !hasJ2EEAgent);
	}
}
