/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class CTree
{
  protected ArrayList fAgentTypeList;	
	
  protected Label _label;
  protected Tree  _tree;  
  protected Composite groupWidget;

  public CTree(Composite parent, String text)
  {
	// Create the grid.
	groupWidget = new Composite (parent, SWT.NULL);

	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	groupWidget.setLayout(layout);  
	GridData data = GridUtil.createFill();
	data.heightHint = 200;
	data.widthHint = 250;   
	groupWidget.setLayoutData(data);

	_label = new Label(groupWidget, SWT.NULL);
	_label.setText(text);
	_tree = new Tree (groupWidget, SWT.MULTI|SWT.BORDER| SWT.H_SCROLL | SWT.V_SCROLL);  
  } 
   
  public TreeItem addItem(TreeItem item, boolean select)
  {

	  if(item.getParentItem() != null)
	  {//agent item

		  //add the process item
		  TreeItem pItem = getItem(item.getParentItem().getData());
		  if(pItem == null)
		  {
			  pItem = new TreeItem(_tree, SWT.NONE);
			  setItemData(pItem, item.getParentItem().getData());
		  }

		  //add the agent item
		  TreeItem agent = getItem(pItem, item.getText());
		  if(agent == null)
		  {
			  agent = new TreeItem(pItem, SWT.NONE);
			  setItemData(agent, item.getData());
		  }
		  
		  if(select)
			  _tree.setSelection(new TreeItem[] {agent});
		  
		  return pItem;
	  }
	  else
	  {//process item

		  //TreeItem pItem = getItem(item.getText());
		  TreeItem pItem = getItemEntry(item);		  
		  if(pItem == null)
		  {        
			  pItem = new TreeItem(_tree, SWT.NONE);
			  setItemData(pItem, item.getData());
		  }

		  //add process agents
		  TreeItem[] agents = item.getItems();
		  for(int idx=0; idx<agents.length; idx++)
		  {
			  TreeItem agent = getItem(pItem, agents[idx].getText());
			  if(agent == null)
			  {           
				  agent = new TreeItem(pItem, SWT.NONE);
				  setItemData(agent, agents[idx].getData());
			  }
		  }

		  if(select)
			  _tree.setSelection(new TreeItem[] {pItem});
		  
		  return pItem;
	  }   
  }  
  public  void clearSelection()
  {
	_tree.deselectAll();
  }  
  public boolean contains(String item)
  {
	 TreeItem[] items = _tree.getItems();

	 for(int idx=0; idx<items.length; idx++)
	 {       
		 if(items[idx].getData().equals(item))
		   return true;
	 }
	 
	 return false;
  }  
/**
 * Insert the method's description here.
 * Creation date: (11/01/2000 1:26:02 PM)
 * @return com.ibm.swt.widgets.TreeItem
 * @param parent com.ibm.swt.widgets.TreeItem
 * @param data java.lang.Object
 * @param select boolean
 */
public TreeItem createItem(TreeItem parent, Object data, boolean select)
{
	TreeItem item=null;
	
	if(parent == null)
	{//process
		String name=((Process)data).getName();
		if(name == null) {
			name=((Process)data).getExecutable();
		}
		item = getItem(name);

		if(item == null) {
			item = new TreeItem(_tree, SWT.NONE);
		}
	}
	else
	{
		item = new TreeItem(parent, SWT.NONE);
	}

	setItemData(item, data);
	
	return item;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/2000 3:12:14 PM)
 * @param enable boolean
 */
public void enable(boolean enable)
{
	_tree.setEnabled(enable);
	_label.setEnabled(enable);      
}
  public int getItemCount()
  {
  	 if (_tree != null)
  	 	return _tree.getItemCount();
  	 else
  	 	return 0;
  }
  
  public TreeItem getItem(int position)
  {
	TreeItem[] items = _tree.getItems();

	if(position < items.length)
	  return items[position];
	  
	return null;
  }  
  
  protected TreeItem getItemEntry(Object item)
  {
	 if(item==null) {
		return null;
	 }

	 TreeItem[] items = _tree.getItems();

	 for(int idx=0; idx<items.length; idx++)
	 {       
		 if(items[idx].getData().equals(((TreeItem)item).getData()))
			   return items[idx];
	 }
	 return null;
  }
  
protected TreeItem getItem(Object data)
  {
	 if(data==null) {
		return null;
	 }

	 TreeItem[] items = _tree.getItems();

	 for(int idx=0; idx<items.length; idx++)
	 {       
		 if(items[idx].getData().toString().equals(data.toString()))
			   return items[idx];
	 }
	 
	 return null;
  }        /**
 * Insert the method's description here.
 * Creation date: (11/09/2000 11:18:59 AM)
 */ 
  protected TreeItem getItem(TreeItem parent, Object data)
  {
	 if(parent == null)
	   return getItem(data);
	   
	 TreeItem[] items = parent.getItems();

	 for(int idx=0; idx<items.length; idx++)
	 {       
		 if(items[idx].getData().toString().equals(data.toString()))
		   return items[idx];
	 }
	 
	 return null;
  }  
  public TreeItem[] getSelectedItems()
  {
	  return _tree.getSelection();
  }  
  public Tree getTree() {
	  return _tree;
  }  
  public Composite getWidget()
  {
	  return groupWidget;
  }  
/**
 * Insert the method's description here.
 * Creation date: (11/01/2000 2:55:50 PM)
 * @param nodes com.ibm.etools.perftrace.TRCNode[]
 */

public void addProcessToTree(Process process, boolean showAll, boolean showAttached)
{
		Enumeration agents =process.listAgents();
	
		boolean logAgentsEnabled=UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.LOG_OPTION_KEY);
		boolean profileAgentsEnabled=UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);
		if(showAll || agents.hasMoreElements())
		{
			TreeItem item = null;
			while(agents.hasMoreElements())
			{
				Agent agent = (Agent)agents.nextElement();
				if(agent.isActive() && (showAttached || !agent.isAttached(true))) {
					if(logAgentsEnabled && agent.getType().equals(TraceConstants.LOG_AGENT_TYPE)){// && agent.isActive() && !agent.isAttached()) {
						if(item==null) {
					 		item = createItem(null, process, false);
					 	}
					 	createItem(item, agent, false);
					}
					else if(profileAgentsEnabled && agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
						if(item==null) {
					 		item = createItem(null, process, false);
					 	}
					 	createItem(item, agent, false);
					}
					
					else
					{
						ArrayList agentList = getAgentTypeList();
						for (int i=0;i<agentList.size();i++)
						if (!(agent.getType().equals(TraceConstants.LOG_AGENT_TYPE)) 
						&& (agent.getType().equals((String)(agentList.get(i))))
						)	
						{
							if(item==null) {
					 		item = createItem(null, process, false);
					 		}
							createItem(item, agent, false);	
						}
					}
				}
			}
		}
}


public void initializeTree(Enumeration processes, boolean showAll, boolean showAttached)
{
	removeAll();
	
	if(processes == null)
	  return;
	
	_tree.setRedraw(false);
	  
	while(processes.hasMoreElements())
	{
		addProcessToTree((Process) processes.nextElement(),showAll, showAttached);       
	}

	_tree.setRedraw(true);
}

  /**
  *
  */
  public void refreshTree(Vector list)
  {
	if(list.size() < 2)
	   return;
		
	_tree.setRedraw(false);
	for(int idx=0; idx< list.size(); idx++)
	{
		TreeItem item = (TreeItem)list.elementAt(idx);

		TreeItem newItem = new TreeItem(_tree, SWT.NONE);
		setItemData(newItem, item.getData());

		TreeItem[] agents = item.getItems();
		for(int i=0; i<agents.length; i++)
		{
			TreeItem newAgent = new TreeItem(newItem, SWT.NONE);
			setItemData(newAgent, agents[i].getData());
		}

		//remove previous item
		item.dispose();
	}

	_tree.setRedraw(true);
 } 
  public void remove(TreeItem item)
  {
	 TreeItem parent = item.getParentItem();
				
	item.dispose();
	if(parent != null && parent.getItemCount() == 0)
	  parent.dispose();
  }  
public void removeAll()
{
	_tree.removeAll();
}/**
 * Insert the method's description here.
 * Creation date: (11/01/2000 1:36:09 PM)
 */ 
protected void setItemData(TreeItem item, Object data)
{
	  item.setData(data);
	  
	  if(item.getParentItem() == null) //processes
	  {
		  /* RKD:  Ideally we would like to list the process by name.  But since this
		         isn't fully implemented correctly we may have to default to the 
		         executable name.
		  */
		  String text=((Process)data).getName();
		  if(text==null) {
			text=((Process)data).getExecutable();
		  }

		  try {
			  text = text+"[PID:"+((Process)data).getProcessId()+"]";
		  }
		  catch(InactiveProcessException exc){}
		  
		  item.setText(text);
		  item.setImage(PDPluginImages.getImage(PDPluginImages.IMG_UI_PROCESS));        
	  }
	  else //agents
	  {
			
		  item.setText(((Agent)data).getName());
		  item.setImage(PDPluginImages.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT));          
	  }
}
   public void setToolTipText(String text)
   {
		_tree.setToolTipText(text);
   }   
	public void sortSubItem(Vector v)
	{
		for (int i=0;i<v.size();i++)
		{
			TreeItem ti = (TreeItem)(v.elementAt(i));
			TreeItem[] _c = ti.getItems();

			if(_c == null || _c.length == 0)
			  return;
			  
			Vector c = new Vector(_c.length);
			
			for(int idx=0; idx<_c.length; idx++)
			  c.addElement(_c[idx]);
				
			refreshAgents(c,ti);
			
		}
	}
	
  public void refreshAgents(Vector list,TreeItem parent)
  {
	if(list.size() < 2)
	   return;
		
	_tree.setRedraw(false);
	for(int idx=0; idx< list.size(); idx++)
	{
		TreeItem item = (TreeItem)list.elementAt(idx);

		TreeItem newItem = new TreeItem(parent, SWT.NONE);
		setItemData(newItem, item.getData());

		//remove previous item
		item.dispose();
	}

	_tree.setRedraw(true);
 }
 
     /**
      * 
      * @return ArrayList
      */
 	 protected ArrayList getAgentTypeList()
	 {
	 	if(fAgentTypeList == null)
	 	{
			fAgentTypeList = new ArrayList();
			fAgentTypeList.add("Logging");
	 	}
	 	return fAgentTypeList;  
	 
	 }

}
