/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;

public class MonitorDrillDownComposite extends Composite
{
	private ToolBarManager toolBarMgr;
	private TreeViewer fChildTree;
	private MonitorDrillDownAdapter adapter;
/**
 * Constructs a new DrillDownTreeViewer.
 *
 * @param parent the parent composite for this control
 * @param style the SWT style for this control
 */
public MonitorDrillDownComposite(Composite parent, int style) {
	super(parent, style);
	createNavigationButtons();
}
/**
 * Creates the navigation buttons for this viewer.
 */
protected void createNavigationButtons() 
{
	GridData gid;
	GridLayout layout;

	// Define layout.
	layout = new GridLayout();
	layout.marginHeight = layout.marginWidth = 
		layout.horizontalSpacing = layout.verticalSpacing = 0;
	setLayout(layout);

	// Create a toolbar.
	toolBarMgr = new ToolBarManager(SWT.FLAT);
	ToolBar toolBar = toolBarMgr.createControl(this);
	gid = new GridData();
	gid.horizontalAlignment = GridData.FILL;
	gid.verticalAlignment = GridData.BEGINNING;
	toolBar.setLayoutData(gid);
}
/**
 * Sets the child viewer.  This method should only be called once, after the
 * viewer has been created.
 *
 * @param aViewer the new child viewer
 */
public void setChildTree(TreeViewer aViewer) {
	// Save viewer.
	fChildTree = aViewer;

	// Create adapter.
	adapter = new MonitorDrillDownAdapter(fChildTree);
	adapter.addNavigationActions(toolBarMgr);
	toolBarMgr.update(true);
	
	// Set tree layout.
	GridData gid = new GridData();
	gid.grabExcessHorizontalSpace = gid.grabExcessVerticalSpace = true;
	gid.horizontalAlignment = gid.verticalAlignment = GridData.FILL;
	fChildTree.getTree().setLayoutData(gid);
	layout();
}
}
