/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.swt.widgets.Display;
/**
 * This adapter listens for changes to objects in a DBResource and updates the
 * database accordingly.
 */
public class ProcessProxyAdapter extends AdapterImpl {

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		if (notification.getEventType()==Notification.SET
				&& notification.getFeature()==HierarchyPackage.eINSTANCE.getTRCProcessProxy_Name())
		{
			Display.getDefault().syncExec(
					new Runnable(){
						public void run(){
							INavigator nav = HyadesUtil.getActiveNavigator();
							nav.getViewer().refresh();
						}
					});
		}
	}
}
