/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model;

/**
 * @author marcelop
 * @since 1.0.2
 */
public abstract class Action
extends NamedElement
{
	private IActionOwner owner;
	private boolean synchronous;
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.NamedElement#dispose()
	 */
	public void dispose()
	{
		owner = null;
		super.dispose();
	}

	
	public void setOwner(IActionOwner newOwner)
	{
		if(owner != null)
			owner.getActions().remove(this);
			
		owner = newOwner;
		
		if(owner != null)
			owner.getActions().add(this);
	}
	
	public IActionOwner getOwner()
	{
		return owner;
	}
	
	public boolean isSynchronous()
	{
		return synchronous;
	}

	public void setSynchronous(boolean synchronous)
	{
		this.synchronous = synchronous;
	}
}
