/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
class MessageDialog
extends JDialog
{
	private final static Dimension DIALOG_SIZE = new Dimension(400, 250);
	
	private NamedElement namedElement;
	private JTextArea messageText;
	
	private MessageDialog(JFrame owner, NamedElement namedElement)
	{
		super(owner, RemoteAppResourceBundle.getString("dialog.Title"), true);
		setResizable(true);
		
		this.namedElement = namedElement;
		
		getContentPane().add(createControls());
		
		addWindowListener(new WindowAdapter()
		{
			public void windowOpened(WindowEvent e)
			{
				dialogOpened();
			}
			
			public void windowClosing(WindowEvent e)
			{
				endDialog();
			}
		});
		
		setSize(DIALOG_SIZE);
	}
		
	private Component createControls()
	{
		final JButton sendButton = new JButton(RemoteAppResourceBundle.getString("dialog.Send"));
		SwingUtil.adjustMnemonic(sendButton);
		sendButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				sendMessage();
			}
		});
		sendButton.setEnabled(false);
		
		JButton closeButton = new JButton(RemoteAppResourceBundle.getString("dialog.Close"));
		SwingUtil.adjustMnemonic(closeButton);
		closeButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				endDialog();
			}
		});
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(sendButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
		buttonPanel.add(closeButton);


		JLabel label = new JLabel(RemoteAppResourceBundle.getString("dialog.Message"));
		SwingUtil.adjustMnemonic(label);
		messageText = new JTextArea();
		messageText.addCaretListener(new CaretListener()
		{
			public void caretUpdate(CaretEvent e)
			{
				if(sendButton != null)
					sendButton.setEnabled(!BaseString.toString(getMessage()).equals(""));
			}
		});		
		
		JScrollPane scrollPane = new JScrollPane(messageText, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		
		JPanel commentPanel = new JPanel(new BorderLayout());
		commentPanel.add(label, BorderLayout.NORTH);
		commentPanel.add(scrollPane, BorderLayout.CENTER);
		
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(commentPanel, BorderLayout.CENTER);
		panel.add(buttonPanel, BorderLayout.SOUTH);
		
		return panel;
	}


	protected void sendMessage()
	{
		ModelUtil.getEventLogger().logMessage(namedElement, MessageEvent.INFO, getMessage());
		endDialog();
	}
	
	protected String getMessage()
	{
		return messageText.getText();
	}
	
	protected void dialogOpened()
	{
		messageText.requestFocus();
	}
		
	protected void endDialog()
	{
		dispose();
	}
	
	public static void show(JFrame owner, NamedElement namedElement)
	{
		MessageDialog dialog = new MessageDialog(owner, namedElement);
		dialog.show();
	}	
}
