/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.outputter.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.ProcessUnitTypeItemProvider;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterConfigTypeItemProvider
	extends ProcessUnitTypeItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_OUT_DESCR");
	public static final String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_OUT_ID");
	
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterConfigTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addTypePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_OutputterConfigType_type_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OutputterConfigType_type_feature", "_UI_OutputterConfigType_type"),
				 OutputterPackage.eINSTANCE.getOutputterConfigType_Type(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
//			childrenFeatures.add(OutputterPackage.eINSTANCE.getOutputterConfigType_SingleFileOutputterType());
//			childrenFeatures.add(OutputterPackage.eINSTANCE.getOutputterConfigType_StandardOutOutputterType());
//			childrenFeatures.add(OutputterPackage.eINSTANCE.getOutputterConfigType_LoggingAgentOutputterType());
//			childrenFeatures.add(OutputterPackage.eINSTANCE.getOutputterConfigType_NotificationOutputterType());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}


	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
//			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_SingleFileOutputterType());
//			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_StandardOutOutputterType());
//			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_LoggingAgentOutputterType());
//			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_NotificationOutputterType());
		}
		return childrenReferences;
	}

	/**
	 * This returns OutputterConfigType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_OUTPUTTER);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String label = ((OutputterConfigType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_OutputterConfigType_type") :
			getString("_UI_OutputterConfigType_type") + " [" + label + "]";
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(OutputterConfigType.class)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

//		newChildDescriptors.add
//			(createChildParameter
//				(OutputterPackage.eINSTANCE.getOutputterConfigType_SingleFileOutputterType(),
//				 OutputterFactory.eINSTANCE.createSingleFileOutputterTypeType()));
//
//		newChildDescriptors.add
//			(createChildParameter
//				(OutputterPackage.eINSTANCE.getOutputterConfigType_StandardOutOutputterType(),
//				 OutputterFactory.eINSTANCE.createStandardOutOutputterTypeType()));
//
//		newChildDescriptors.add
//			(createChildParameter
//				(OutputterPackage.eINSTANCE.getOutputterConfigType_LoggingAgentOutputterType(),
//				 OutputterFactory.eINSTANCE.createLoggingAgentOutputterTypeType()));
//
//		newChildDescriptors.add
//			(createChildParameter
//				(OutputterPackage.eINSTANCE.getOutputterConfigType_NotificationOutputterType(),
//				 OutputterFactory.eINSTANCE.createNotificationOutputterTypeType()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
