/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.util.AcadPerspective;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;


/**
 */
public class ContentView extends ViewPart 
{
	private final String CONTENT_TITLE = AcadEditorPlugin.getPlugin().getString("LOG_CONTENT");

	TextViewer contentViewer;	
		
	/**
	 * Constructor
	 */
	public ContentView() {
		super();
		
	}

	/**
	 * @see IViewPart.init(IViewSite)
	 */
	public void init(IViewSite site) throws PartInitException {
		super.init(site);
	}

	/**
	 * Initializes this view with the given view site.  A memento is passed to
 	 * the view which contains a snapshot of the views state from a previous
	 * session.  	
	 */
	public void init(IViewSite site,IMemento memento) throws PartInitException {
		init(site);
		
		enableEditActions();
		
	}
	
	/**
	 * @see IWorkbenchPart#createPartControl(Composite)
	 */
	public void createPartControl(Composite parent) {
		
		contentViewer = new TextViewer(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.WRAP);
		contentViewer.setEditable(false);
		
		set_Title();
		
		WorkbenchHelp.setHelp(parent, ContextIds.ACAD_EDITOR_CONTENT_VIEW);
		
	}
	
	public void showLog()
	{
		if(AcadGuiModelManager.getCurrentModel() != null)
			setContent(AcadGuiModelManager.getCurrentModel().getLogContent());
	}
	
	/**
	 * @see WorkbenchPart#setFocus()
	 */
	public void setFocus() {
		if(contentViewer != null && contentViewer.getControl().isDisposed())
			contentViewer.getControl().setFocus();
	}


	/**
	 * Returns the image descriptor with the given relative path.
	 */
	
	private ImageDescriptor getImageDescriptor(String relativePath) {
		
		
		String iconPath = "icons/full/elcl16/";
		try {
			
			URL installURL = AcadEditorPlugin.getPlugin().getBaseURL();
			URL url = new URL(installURL, iconPath + relativePath);
			
			return ImageDescriptor.createFromURL(url);
			
			
		}
		catch (MalformedURLException e) {
			// should not happen
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	
	
	/**
	 * Hook global actions
	 */
	private void hookGlobalActions() {
		IActionBars bars = getViewSite().getActionBars();
	}
		
	private void updateActionEnablement() {
	}
					
	public void set_Title()
	{
		AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
		
		StringBuffer title = (new StringBuffer(CONTENT_TITLE)).append(" ");
		
		if(model != null)
		{
			long currentEvent = model.getCurrentCount();
			if(currentEvent >=0 ) 
			  currentEvent++;
			else 
			  currentEvent = 0;  
			
			if(model.getContextInstance() == null || model.getContextInstance().eContainer() == null)
			{  
				title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
			}
			else
			{
				SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(model);
				if(sensor != null)
				{  
// TODO check this fragment
//					SensorType type = sensor.getType();
//				
//					switch(type.getValue())
//					{
//						case SensorType.ADAPTER_CBE_SENSOR:
//						  title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
//						  break;
//						case SensorType.SINGLE_FILE_SENSOR:
//						  SingleFileSensorType fileSensor = sensor.getSingleFileSensor();
//						  if(fileSensor == null)
//							title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
//						  else
//							title.append(fileSensor.getDirectory()).append(File.separator)
//								  .append(fileSensor.getFileName());	
//						  break;
//					}
					
					if(model.getEventCount() > 0)
					{
						String msg = AcadEditorPlugin.getPlugin().getString("STR_CONTENT_TITLE", new Object[] {"0", String.valueOf(model.getEventCount())});
						title.append(" ").append(msg);						
					}
				}
				else
				{
					title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
				}
				
			}
				 				 			
		}
		
		super.setTitle(title.toString());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose() 
	{
		// Auto-generated method stub
		super.dispose();
	}
	
	public String getText()
	{
		return ((StyledText)contentViewer.getControl()).getText();
	}
	/**
	 * 
	 * @return
	 */
	public static final ContentView getContentView(boolean show)
	{
		try {
			IWorkbenchPage page = AcadEditorPlugin.getDefault().getActivePage();
			if(page == null)
			  return null;
			
			IViewPart view = null;				

			if(show)
			{
				view = page.showView(AcadPerspective.ID_CONTENTVIEW);
	
				if (view != null && view instanceof ContentView)
				{
					return (ContentView) view;	
	
				}				
			}
			
			view = page.findView(AcadPerspective.ID_CONTENTVIEW);;	
			if (view != null && view instanceof ContentView)
			{
				return (ContentView) view;	
				
			}
			
		}
		catch(Exception exc)
		{
//			AcadEditorPlugin.INSTANCE.log(exc);
			return null;
		}
		
		return null;
	}

    public void reset()
    {
     	setContent("");
    }
    
    public void setContent(String text)
    {
    	if(contentViewer != null && text != null)
			contentViewer.setDocument(new Document(text));
    }
    
	protected void enableEditActions()
	{
		ActionHandlerListener.DEFAULT.connectPart(this);
	}

}
