/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;

/**
 * This class represents a generic database command.
 */
public class DBCommand {
	protected JDBCHelper helper;

	protected DBMap dbMap;

	protected DatabaseType dbType;

	protected static boolean debug = false;

	protected boolean usePreparedStatement = true;

	/**
	 * Constructor for DBCommand.
	 */
	public DBCommand(JDBCHelper helper, DBMap map) {
		super();
		this.dbType = helper.getDatabaseType();
		this.helper = helper;
		dbMap = map;
	}

	protected String addQuotes(String name) {
		if (!helper.getDatabaseType().getAddQuotes())
			return name;
		else
			return "\"" + name + "\"";
	}

	/**
	 * Executes the command, and returns a result, which may be null.
	 */
	public Object execute() throws Exception {
		throw new UnsupportedOperationException();
	}

} // DBCommand
