/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.internal.sdb.SDBPackage;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.InternalDatabase;
import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.util.IDatabaseExtensions;
/**
 * @author slavescu
 */
/**
 * @author slavescu
 */
public class DBHyadesResourceExtension implements IHyadesResourceExtension {
	public static final String DB_NAME = "Hyades";
	protected Map databases = new HashMap();
	protected Database getDatabase(String postfix, Properties properties) throws Exception {
		DatabaseType databaseType = getDBType(postfix);
		Database database = (Database) databases.get(databaseType);
		if (database != null) {
			if (!database.getProperties().equals(properties)) {
				database.setProperties(properties);
				database.close();
			} else
				return database;
		} else
			database = ((IDatabaseExtensions) DatabaseExtensions.getInstance().get(postfix)).createDatabase(DB_NAME, properties);
		//		database =
		// factory.createDatabase((databaseType.toString().equals("MySQL") ?
		// "///" : "") + DB_NAME, properties, databaseType);
		if (database == null)
			return null;
		TypeMap map = database.getTypeMap();
		//		map.add("EDouble", Types.VARCHAR);
		map.setVarCharLength(databaseType.getVarcharMaxSize());
		initDBMap(database);
		database.setCaching(true);
		//		database.setCacheSize(5000);
		try {
			database.open(false);
			databases.put(databaseType, database);
		} catch (Exception e) {
			LoadersUtils.log(e);
			try {
				database.open(true);
				databases.put(databaseType, database);
			} catch (Exception e1) {
				LoadersUtils.log(e1);
				return null;
			}
		}
		//		try {
		//			database.dropTables();
		//			database.createTables();
		//		} catch (Exception e) {
		//			if(e instanceof DBCollectedExceptions)
		//				database.createTables();
		//			else
		//				e.printStackTrace();
		//		}
		return database;
	}
	public IHyadesExtendedResource createResource(URI uri, Properties properties) {
		DBResource resource = null;
		try {
			String postfix = LoadersUtils.getPostfix(uri);
			Database database = getDatabase(postfix, properties);
			resource = new DBResourceImpl(uri, database);
		} catch (Exception e) {
			throw new DBCollectedExceptions(e);
		}
		return resource;
	}
	protected DatabaseType getDBType(String postfix) {
		return ((IDatabaseExtensions) DatabaseExtensions.getInstance().get(postfix)).getDBType();
	}
	/**
	 *  
	 */
	public DBHyadesResourceExtension() {
		// empty
		//		 IExtensionPoint point =
		// Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.resources.database.internal","database_extensions");
		//		 
		//		 System.out.println(point);
	}
	/**
	 * Creates a default DBMap for the Hyades Log model.
	 */
	protected void initDBMap(Database database) {
		List packages = new ArrayList();
		packages.add(EcorePackage.eINSTANCE);
		packages.add(HierarchyPackage.eINSTANCE);
		packages.add(CBEPackage.eINSTANCE);
		packages.add(SDBPackage.eINSTANCE);
		database.setDBMap(packages);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int, int)
	 */
	public EList createPagingList(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
		return PagingListFactory.INSTANCE.createPagingList(dataClass, owner, featureID, inverseFeatureID);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int)
	 */
	public EList createPagingList(Class dataClass, EObject owner, int featureID) {
		return PagingListFactory.INSTANCE.createPagingList(dataClass, owner, featureID);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(org.eclipse.emf.ecore.EObject,
	 *      org.eclipse.emf.ecore.EStructuralFeature)
	 */
	public EList createPagingList(EObject owner, EStructuralFeature eStructuralFeature) {
		return PagingListFactory.INSTANCE.createPagingList(owner, eStructuralFeature);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#getPagingSize()
	 */
	public int getPagingSize() {
		return PagingListFactory.INSTANCE.getPagingSize();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#setPagingSize(int)
	 */
	public void setPagingSize(int size) {
		PagingListFactory.INSTANCE.setPagingSize(size);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#isEnabledFor(java.lang.String)
	 */
	protected boolean isEnabled(IDatabaseExtensions extension) {
		JDBCHelper jdbcHelper = extension.getJDBCHelper();
		try {
			//check if driver exists
			jdbcHelper.loadJDBCDriver();
		} catch (Exception e) {
//			System.out.println("Driver for " + extension + "does not exist.");
			//								e.printStackTrace(System.out);
			return false;
		}
		return true;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#createResource(org.eclipse.emf.common.util.URI,
	 *      java.util.List)
	 */
	public IHyadesExtendedResource createResource(URI uri, Properties properties, Collection notLoaded) {
		DBResource resource = (DBResource) createResource(uri, properties);
		if (resource != null) {
			resource.getDefaultLoadOptions().put(DBResource.OPTION_NOT_LOADED_CLASSES, notLoaded);
			resource.getDefaultLoadOptions().put(DBResource.OPTION_TOP_LEVEL, Boolean.TRUE);
		}
		return resource;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#getStoreType()
	 */
	public String getStoreType(String postfix) {
		return ((IDatabaseExtensions) DatabaseExtensions.getInstance().get(postfix)).getExtensionName();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#createTables(java.lang.String)
	 */
	public boolean createTables(String storeType, Properties properties) {
		Database database;
		try {
			database = getDatabase("__" + storeType + ".trcadb", properties);
			if (database != null) {
				try {
					database.createTables();
				} catch (Exception e) {
					//					 TODO : MS - add better handling
					e.printStackTrace();
					return false;
				}
				return true;
			}
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#dropTables(java.lang.String)
	 */
	public boolean dropTables(String storeType, Properties properties) {
		Database database;
		try {
			database = getDatabase("__" + storeType + ".trcadb", properties);
			if (database != null) {
				try {
					database.dropTables();
				} catch (Exception e) {
					//					 TODO : MS - add better handling
					LoadersUtils.log(e);
					return false;
				}
				return true;
			}
		} catch (Exception e1) {
			LoadersUtils.log(e1);
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IHyadesResourceExtension#getSupportedPostfixes()
	 */
	public List getSupportedPostfixes() {
		List prefixes = new ArrayList();
		Set processed = new HashSet();
		for (Iterator iter = DatabaseExtensions.getInstance().entrySet().iterator(); iter.hasNext();) {
			Map.Entry entry = (Map.Entry) iter.next();
			if (!processed.contains(entry.getKey()) && entry.getKey() instanceof String) {
				processed.add(entry.getKey());
				if (isEnabled((IDatabaseExtensions) entry.getValue()))
					prefixes.add(entry.getKey());
			}
		}
		return prefixes;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int, int)
	 */
	public EMap createPagingMap(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int)
	 */
	public EMap createPagingMap(Class dataClass, EObject owner, int featureID) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(org.eclipse.emf.ecore.EObject,
	 *      org.eclipse.emf.ecore.EStructuralFeature)
	 */
	public EMap createPagingMap(EObject owner, EStructuralFeature eStructuralFeature) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query,
	 *      org.eclipse.emf.ecore.resource.ResourceSet)
	 */
	public QueryResult executeQuery(Query query, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		QueryResult queryResult = null;
		try {
			String firstURI = (String) query.getSources().get(0);
			InternalDatabase db = getInternalDatabase(firstURI);
			if (db == null) {
				getDatabase(LoadersUtils.getPostfix(firstURI), HyadesResourceExtensions.getInstance().getProperties());
				db = getInternalDatabase(firstURI);
			}
			if (db.isCaching()) {
				db.forceUpdates();
			}
			WeakObjectCache cache = db.getObjectCache();
			if (query instanceof TimeBasedCorrelationQuery) {
				DBCommand ssc = DBCommandFactory.INSTANCE.createTimeBaseCorrelationCommand(getFirstJDBCHelper(query), getFirstDBMap(query), (TimeBasedCorrelationQuery) query, targetResourceSet, cache, notLoadedTypes);
				queryResult = (QueryResult) ssc.execute();
				return queryResult;
			} else if (query instanceof SimpleSearchQuery) {
				DBCommand ssc = DBCommandFactory.INSTANCE.createSimpleSearchCommand(getFirstJDBCHelper(query), getFirstDBMap(query), (SimpleSearchQuery) query, targetResourceSet, cache, notLoadedTypes);
				queryResult = (QueryResult) ssc.execute();
			} else
				throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
		} catch (Exception e) {
			throw new DBCollectedExceptions(e);
		}
		return queryResult;
	}
	/**
	 * @param string
	 * @return
	 */
	private InternalDatabase getInternalDatabase(String uri) {
		String postfix = LoadersUtils.getPostfix(uri);
		DatabaseType databaseType = getDBType(postfix);
		Database database = (Database) databases.get(databaseType);
		if (database != null) {
			return (InternalDatabase) database;
		}
		return null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(java.lang.String,
	 *      org.eclipse.emf.ecore.resource.ResourceSet)
	 */
	public QueryResult executeQuery(String queryName, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#storeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean storeQuery(Query query) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#validateQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean validateQuery(Query query) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/**
	 * @param query
	 * @return
	 */
	protected DBMap getFirstDBMap(Query query) {
		if (query == null || query.getSources().size() == 0)
			return null;
		String url = (String) query.getSources().get(0);
		DatabaseType databaseType = getDBType(LoadersUtils.getPostfix(url));
		Database database = (Database) databases.get(databaseType);
		if (database != null) {
			return database.getDBMap();
		}
		return null;
	}
	/**
	 * @param query
	 * @return
	 */
	protected JDBCHelper getFirstJDBCHelper(Query query) {
		if (query == null || query.getSources().size() == 0)
			return null;
		String url = (String) query.getSources().get(0);
		DatabaseType databaseType = getDBType(LoadersUtils.getPostfix(url));
		Database database = (Database) databases.get(databaseType);
		if (database != null) {
			return database.getJDBCHelper();
		}
		return null;
	}
}