/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;
import java.util.HashMap;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.resources.database.util.IDatabaseExtensions;
/**
 * @author slavescu
 */
public class DatabaseExtensions extends HashMap {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	private static DatabaseExtensions instance;
	//~ Constructors
	// -------------------------------------------------------------------------------
	/**
	 *  
	 */
	private DatabaseExtensions() {
		super();
	}
	//~ Methods
	// ------------------------------------------------------------------------------------
	/**
	 *  
	 */
	public static DatabaseExtensions getInstance() {
		if (instance == null) {
			instance = new DatabaseExtensions();
			new DatabaseRegistryReader().readRegistry();
		}
		return instance;
	}
}
/**
 * A plugin extension reader that populates the loaders registry. Clients are
 * not expected to use this class directly.
 */
class DatabaseRegistryReader extends RegistryReader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	static final String TAG_DATABASE_EXTENSION = "databaseExtension";
	static final String ATT_CLASS = "class";
	//~ Constructors
	// -------------------------------------------------------------------------------
	public DatabaseRegistryReader() {
		super("org.eclipse.hyades.resources.database", RegistryReader.DATABASE_EXTENSIONS_PPID);
	}
	//~ Methods
	// ------------------------------------------------------------------------------------
	protected boolean readElement(HyadesConfigurationElement element) {
		if (element.getName().equals(TAG_DATABASE_EXTENSION)) {
			if (element.getAttribute(ATT_CLASS) == null) {
				logMissingAttribute(element, ATT_CLASS);
			} else {
				try {
					IHyadesPluginClassDescriptor classDescriptor = createPluginClassDescriptor(element, ATT_CLASS);
					IDatabaseExtensions databaseExtensions = (IDatabaseExtensions) classDescriptor.createInstance();
					DatabaseExtensions.getInstance().put(databaseExtensions.getDBType(), databaseExtensions);
					for (int i = 0; i < databaseExtensions.getSupportedPostfixes().length; i++) {
						String postfix = databaseExtensions.getSupportedPostfixes()[i];
						if (DatabaseExtensions.getInstance().containsKey(postfix)) {
							logError(element, "A database extension for this postfix already exists, this extension will be ignored.");
						} else {
							DatabaseExtensions.getInstance().put(postfix, databaseExtensions);
						}
					}
					return true;
				} catch (Exception e) {
					logError(element, e.getLocalizedMessage());
				}
			}
		}
		return false;
	}
}