/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EClass;

public class ReferencedObject implements Comparable {
	private EClass eClass;
	private int id;
	private int order;
	public ReferencedObject(EClass eClass, int id, int order) {
		this.eClass = eClass;
		this.id = id;
		this.order = order;
	}
	public EClass getEClass() {
		return eClass;
	}
	public int getId() {
		return id;
	}
	public int getOrder() {
		return order;
	}
	public int compareTo(Object object) {
		ReferencedObject referenced = (ReferencedObject) object;
		if (order < referenced.getOrder())
			return -1;
		else if (order > referenced.getOrder())
			return 1;
		else
			return 0;
	}
}