/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.util;

import org.eclipse.jface.viewers.IStructuredSelection; 
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

import org.eclipse.hyades.security.SecurityPlugin;

public class ImportSecurityCertificate
	extends Wizard
	implements IImportWizard {

	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ImportSecurityCertificatePage page;
	/**
	 * Constructor for ImportSecurityCertificate.
	 */
	public ImportSecurityCertificate() {
		super();
	}

	public void addPages()
	{
	  	setWindowTitle(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WTITLE"));	
		
		super.addPages();
		page = new ImportSecurityCertificatePage(workbench,selection);
		addPage(page);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		
		return page.finish();
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
		
	}

}
