/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogUIPlugin extends AbstractUIPlugin {

	private static LogUIPlugin inst;
	private static ResourceBundle aResourceBundle = null;
	private SDBFactoryImpl factory;
	private ResourceSet resourceSet;
	private ArrayList recordChangeListeners = null; 

	public LogUIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		if (inst == null)
			inst = this;
		aResourceBundle = this.getDescriptor().getResourceBundle();

	}
	public static LogUIPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		return LogUIPluginImages.getImageDescriptor(name);
	}
	public static ResourceBundle getResourceBundle() {
		return aResourceBundle;
	}
	public static String getResourceString(String key) {
		ResourceBundle bundle = LogUIPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	public static String getResourceString(String key, String[] variables) {
		String value = getResourceString(key);
		for(int i=variables.length; i>0; i--)
			value = StringUtil.replace(value, "%"+i, variables[i-1]);
		return value;
	}
	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}

	/**
	 * Logs an exception in Eclipse's .log file.
	 * @param e The exception to log.
	 */
	public static void log(Throwable e) {
		String msg = e.getMessage();
		getDefault().getLog().log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, msg == null ? "" : msg, e));
	}	

	public static SimpleDateFormat getDateTimeFormat(){
		IPreferenceStore store = inst.getPreferenceStore();
		String dateFormat = store.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE);

		boolean valid = false;
		for (int i = 0; i < LogUIConstants.DATE_FORMAT_LIST.length; i++)
			if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
				valid = true;
				break;
			}

		if (!valid)
			dateFormat = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;

		String timeFormat = store.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME);

		valid = false;
		for (int i = 0; i < LogUIConstants.TIME_FORMAT_LIST.length; i++)
			if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
				valid = true;
				break;
			}

		if (!valid)
			timeFormat = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;

		if (timeFormat.startsWith("h"))
			timeFormat = timeFormat + " a";


		java.text.SimpleDateFormat formatter =
				new java.text.SimpleDateFormat(dateFormat + " " + timeFormat);

		return formatter;

	}

	public void shutdown() throws CoreException {
		LogUIPluginImages.shutdown();

		super.shutdown();
	}
	public void startup() throws CoreException {
		SDBPackageImpl.init();

		factory = new SDBFactoryImpl();

		// init resourceSet
		resourceSet = SDBResourceSetImpl.getInstance();
		super.startup();
	}

	public SDBFactoryImpl getSymptomDBFactory() {
		if (factory == null)
			factory = new SDBFactoryImpl();
		return factory;
	}

	/*
	 * 
	 */
	public ResourceSet getResourceSet() {
		return resourceSet;
	}

	/**
	 * Sets default preference values. These values will be used
	 * until some preferences are actually set using Preference dialog.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		
		try {

				ArrayList sort = new ArrayList(40);
				ArrayList filter = new ArrayList(70);

				createSortAndFilterList(sort,filter,CBEPackage.eINSTANCE.getCBECommonBaseEvent());

				sort.remove("timeZone");
				StringBuffer pdSortKey = new StringBuffer();
				generatePreferenceString(pdSortKey, sort, new String[]{"creationTime", "sequenceNumber"});
				store.setDefault(LogUIConstants.PD_SORT_LOG_OPTIONS, pdSortKey.toString().trim());
				
    			filter.remove("timeZone");
    			StringBuffer pdKey = new StringBuffer();					
    			Collections.sort(filter);
				generatePreferenceString(pdKey, filter, null);
				store.setDefault(LogUIConstants.PD_FILTER_OPTIONS, pdKey.toString().trim());
			
				store.setDefault(LogUIConstants.PD_ADV_FILTER_OPTIONS, "");
				store.setDefault(LogUIConstants.PD_SEARCH_FILTER_OPTIONS, "");
				store.setDefault(LogUIConstants.PD_SEARCH_DIRECTION_OPTIONS, "1");
				store.setDefault(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY, "1");
				
			
		} catch (Exception exc) {
			exc.printStackTrace();
		}
				
		store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_DATE, LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
		store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_TIME, LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);
		
	}

	/**
	 * Method generatePrefrenceString.
	 * @param key
	 * @param list
	 */
	private void generatePreferenceString(StringBuffer key, ArrayList list, String[] pref) {
		
		String keyVal = "";
		if(pref==null){
			keyVal = ":1 ";
		}
		else{
			keyVal = ":1 ";
			int s = pref.length;
			for(int i=0; i<s; i++){
				key.append((String)pref[i]);
				key.append(keyVal);
				list.remove(pref[i]);
			}
			keyVal = ":0 ";
			
		}
		
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			key.append(element);
			key.append(keyVal);
			
		}
	}

	
	private void createSortAndFilterList(List sort, List filter, EClassifier base){

		List list = new ArrayList(30);
			
		EList metaObj = CBEPackage.eINSTANCE.getEClassifiers();
		int size = metaObj.size();

		for (int i = 0; i < size; i++) {
			EClassifier elem = (EClassifier)metaObj.get(i);
			getEObjectAttributes((EClass)elem, list);
			int listSize = list.size();
			boolean isSort = ((EClass)elem).getEAllSuperTypes().contains(base) || elem == base;			
			for (int j = 0; j<listSize;j++) {
				String element = (String) list.get(j);
				if(isSort && !sort.contains(element)){
					sort.add(element);
				}
				if(!filter.contains(element)){
					filter.add(element);
				}
				
			}
			list.clear();

		}
				
	}
	
	
	private void getEObjectAttributes(EClass eClass, List list){

		List attributes = eClass.getEAttributes();
		boolean isArrayOfObj = false;
		for (int k=0; k < attributes.size(); k++) {
			EAttribute attribute = (EAttribute) attributes.get(k);
			isArrayOfObj = attribute.isMany() &&  
							(attribute.getEType().getInstanceClass() != String.class) &&
							(!attribute.getEType().getInstanceClassName().equals("byte")) && 
							(!attribute.getEType().getInstanceClassName().equals("short"));
			if(!isArrayOfObj){
				list.add(attribute.getName());
			}
		}
					
	}
	
	
	public void addRecordPaneViewerListener(IRecordPaneViewerListener listener){
		
		if(recordChangeListeners==null){
			recordChangeListeners = new ArrayList();
		}
		
		if(!recordChangeListeners.contains(listener)){
			recordChangeListeners.add(listener);
		}
	}
	
	public void removeRecordPaneViewerListener(IRecordPaneViewerListener listener){
		if(recordChangeListeners!=null){
			recordChangeListeners.remove(listener);
		}
	}
	
	public void fireRecordChangeNotification(RecordChangeEvent e){
		if(recordChangeListeners!=null){
			for(int i=0;i<recordChangeListeners.size();i++){
				((IRecordPaneViewerListener)recordChangeListeners.get(i)).handleRecordChangeEvent(e);
			}
		}
		
	}

}
