/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.viewers.*;

public class FilterElementModifier implements ICellModifier
{
	protected CheckboxTableViewer fViewer;

	public FilterElementModifier(CheckboxTableViewer viewer)
	{
		fViewer = viewer;
	}
	public boolean canModify(Object element, String property) {
		return true;
	}
	public Object getValue(Object element, String property)
	{
		  
		if(property.equals(FilterTableElement.P_ATTRIBUTE))
		  return new Integer(((FilterTableElement)element).getAttributeState());

		if(property.equals(FilterTableElement.P_OPERATOR))
		  return new Integer(((FilterTableElement)element).getOperatorState());

		if(property.equals(FilterTableElement.P_VALUE))
		  return ((FilterTableElement)element).getValue();
		  
		return element;
	}
	public void modify(Object element, String property, Object value)
	{
		try {
		if(element instanceof TableItem)
		{
			Item item = (Item)element;			
			Object data = ((TableItem)element).getData();
			
			if(data != null && data instanceof FilterTableElement)
			{
				FilterTableElement e = (FilterTableElement)data;

				if (FilterTableElement.P_ATTRIBUTE.equals(property))
				{
					if(value != null && Integer.parseInt(value.toString()) != e.getAttributeState())
					{
						e.setAttribute(Integer.parseInt(value.toString()));
					}
						
				}
				else if (FilterTableElement.P_OPERATOR.equals(property))
				{
					if(value != null && Integer.parseInt(value.toString()) != e.getOperatorState())
					{
						e.setOperator(Integer.parseInt(value.toString()));
					}
						
				}
				
				else if (FilterTableElement.P_VALUE.equals(property))
				{
					if(value != null && !e.getValue().equals(value.toString()))
					{
						e.setValue(value.toString());
					}
				}				
			}	
		}
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
	}

}
