/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.jface.viewers.*;

public class FilterList implements IBasicPropertyConstants
{	
	List filters = new ArrayList();	
	TableViewer fViewer;

	private List listeners;

	public FilterList(TableViewer viewer)
	{
		fViewer = viewer;
	}
	public void add(FilterTableElement element)
	{
		add(element, -1);
	}

	public void add(FilterTableElement element, int index)
	{
		if(index < 0)
			filters.add(element);
		else	
			filters.add(index, element);
	}
	
	public void addElementChangedListener(FilterListContentProvider newListener) {
	
		if (newListener == null)
			return;
		if (listeners == null)
			listeners = new ArrayList();
		if (!listeners.contains(newListener))
			listeners.add(newListener);
	
	}
	
	public Object[] elements()
	{
		return filters.toArray();	
	}

	public void fireElementChanged(FilterTableElement changedElement,String changedProperty) {
		// forward change to content providers.
		if (listeners != null) {
			Iterator e = listeners.iterator();
			while (e.hasNext()) {
				FilterListContentProvider l = (FilterListContentProvider) e.next();
				l.elementChanged(changedElement,changedProperty);
			}
		}
	}
		public Object getElementAt(int index) {
			return filters.get(index);
		}
 
	public List getFilters()
	{
		return (List)((ArrayList) filters).clone();
	}
 
	public int getSize() {
		return filters.size();
	}
 
	public void removeAll()
	{
 	   filters.clear();
	}
	
	public void removeElements(int idx[])
	{
		if (idx == null) return;
		
		Vector removeList = new Vector();
		for (int i=0;i<idx.length;i++)
		{
			if (idx[i]!=-1)
			{
				Object element = filters.get(idx[i]);
				removeList.add(element);
			}
		}
		filters.removeAll(removeList);
	}
 
	public Object removeElementAt(int idx)
	{
		Object element = filters.get(idx);
	
		if(element == null)
		  return null;
		  
		filters.remove(element);
		
		return element;
	
	}
	
	public void removeElementChangedListener(FilterListContentProvider listener) {
	
		if (listeners != null)
			listeners.remove(listener);
	}
 
	public Object[] uiElements()
	{
		return filters.toArray();
	}
}
