/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;

/**
 * Provides content for a tree viewer that shows only containers.
 */
public class SymptomDBContentProvider implements ITreeContentProvider {
	private Viewer viewer;
/**
 * Creates a new ResourceContentProvider.
 */
public SymptomDBContentProvider() {
}
/**
 * The visual part that is using this content provider is about
 * to be disposed. Deallocate all allocated SWT resources.
 */
public void dispose() {}
/**
 * @see ITreeContentProvider#getChildren
 */
public Object[] getChildren(Object element)
{
	if (element instanceof IWorkspace)
	{
		return ((IWorkspace) element).getRoot().getProjects();
	}
	else if (element instanceof IContainer)
	{
		List names = new ArrayList();
	    List children = new ArrayList();		
		IContainer container = (IContainer)element;
		if (container.isAccessible())
		{
		    try {

			    IResource[] members = container.members();
			    for (int i = 0; i < members.length; i++)
			    {
				    if (members[i].getType() == IResource.FILE)
				    {
					    IFile file = (IFile) members[i];
					    if(file.getFileExtension() != null && file.getFileExtension().equals("trcdbxmi"))
					    {
						    children.add(file);
						    names.add(file.getName().substring(0, file.getName().length()-file.getFileExtension().length()-1));
					    }
				    }
				    else
					    children.add(members[i]);				    
			    }
			} catch (CoreException e) {
				// this should never happen because we call #isAccessible before invoking #members
			}
			
		    return children.toArray();
			
		}
	}
	return new Object[0];
}
/**
 * @see ITreeContentProvider#getElements
 */
public Object[] getElements(Object element) {
	return getChildren(element);
}
/**
 * @see ITreeContentProvider#getParent
 */
public Object getParent(Object element) {
	if (element instanceof IResource) 
		return ((IResource) element).getParent();
	return null;
}
/**
 * @see ITreeContentProvider#hasChildren
 */
public boolean hasChildren(Object element) {
	return getChildren(element).length > 0;
}
/**
 * @see IContentProvider#inputChanged
 */
public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	this.viewer = viewer;
}
/**
 * @see IContentProvider#isDeleted
 */
public boolean isDeleted(Object element) {
	return ((element instanceof IResource) && !((IResource) element).exists());
}
}
