package org.eclipse.hyades.logging.adapter;
/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
public class AdapterException extends Exception
{
	/**
	 * Constructor for LogParserException.
	 */
	public AdapterException()
	{
		super();
	}
	/**
	 * Constructor for AdapterException.
	 * @param message
	 */
	public AdapterException(String message)
	{
		super(message);
	}
	/**
	 * Constructor for AdapterException.
	 * @param message
	 * @param cause
	 */
	public AdapterException(String message, Throwable cause)
	{
		super(message + "  Exception = " + cause);
	}
	/**
	 * Constructor for AdapterException.
	 * @param cause
	 */
	public AdapterException(Throwable cause)
	{
		super(cause.toString());
	}
}
