/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;
/**
 * ISensor defines the basic Sensor implementation requirements.
 * A Sensor reads data from some source that is to be processed by other
 * components in the context.
 **/
public interface ISensor extends IProcessUnit
{

	/**
	 * Method getNext
	 * Gets the next set of data from the source being sensed.  
	 * This set of data will be passed to the next component for processing. 
	 */
	public Object[] getNext();
	
	/**
	 * Method testGetNext
	 * In order to avoid runtime failures a context should invoke this test method.
	 * An implementation should return a set of data of a type expected by the
	 * consumer component, thus simulating a runtime environment. 
	 */
	public Object[] testGetNext();
	
	/**
	 * Method flush()
	 * This method will be called by the context when it is stopping.
	 * An implementation should return any data from the source that remains 
	 * in any internal sensor buffers that should be processed by the next component.
	 */	
	public Object[] flush();
	
	/**
	  * Method setType. Set the sensor type.
	 */
	public void setType(String newType);
	/**
	  * Method getType 
	  * Returns the sensor type.
	  * @return String
	 */
	public String getType();

}
