/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.internal.util.ComponentLoaderUtil;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
/**
 * <p>Title: ComponentFactory.java</p>
 * <p>Description: Create Component objects
 * </p>
 * @author HS
 * @version 0.1
 * @see 
 **/
public class ComponentFactory
{
	private ComponentFactory()
	{
	}
	public static Component buildComponent(String classname, String id, String name) throws PreparationException {
		Component component = null;
		if (classname != null) {
			try {
			component =(Component)ComponentLoaderUtil.instantiate(classname, "org.eclipse.hyades.logging.adapter.impl.Component");
			}
			catch(PreparationException e) {
				/* Something went wrong building the component.  We need to add some infor to the exception and throw it on up the stack */
            	PreparationException eprime=new PreparationException(Messages.getString("HyadesGAComponentInstantiation_ERROR_", name, e.getMessage()));
            	throw eprime;
			}
			component.setName(name);
			component.setExecutableClassName(classname);
			component.setUniqueID(id);
		}
		return component;
	}
}
