/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.logging.adapter.outputters;

import java.io.IOException;

/**
 * @author rduggan
 *
 * This is a specialized writer that will be thread safe when writing 
 * to the same file
 */
public class CBEConvergentFileOutputter extends CBEFileOutputter {
	
	/* This is a lock for synchronizing access to the underlying file
	 * across a whole record.
	 */
	private static final Object lock=new Object();
	
	
	protected void writeToFile(String event) throws IOException {
		synchronized(lock) {
			fw.write(event);
			fw.write("\n");
			fw.flush();
		}
		
	}
	
	
}
