/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.outputters;

import java.util.Hashtable;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author smith
 *
 * This outputter writes CBE's to a logging agent
 * 
 */
public class CBELogOutputter extends Outputter implements IOutputter {
	private LoggingAgent cbelogger = null;
	
	private static String defaultAgentName = "GenericAdapterCBELogger";
	
	private String agentName = null;
	
	private long waitTime = 0;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(java.lang.Object[])
	 */
	public Object[] processEventItems(Object[] msgs) {
		if (msgs == null)
			return null;
		return processCBEs((CommonBaseEvent[]) msgs);
	}

	/**
	 * Process the CBE events passed in.
	 * @param events CBE events to process
	 * @return CommonBaseEvent[]
	 */
	private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events)
	{
		// If the agent is not being monitored then wait for it to be so
		
		if (events.length > 0 && !cbelogger.isLogging() && getWaitTime() > 0) {

		    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();

		    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
		    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID(),getAgentName()});							    

		    event.setSeverity(CommonBaseEvent.SEVERITY_INFORMATION);
			
		    log(event);
			
		    while ( !cbelogger.waitUntilLogging(getWaitTime())) {

			    event = getEventFactory().createCommonBaseEvent();
			   
			    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
			    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID(),getAgentName()});							    

			    event.setSeverity(CommonBaseEvent.SEVERITY_INFORMATION);

			    log(event);
			} 
			
/*          This does not work - waitUntilLogging is not returning true after user attaches to 
			agent but it should. 
 
			if (!cbelogger.waitUntilLogging(60000)) {
				if (!cbelogger.isLogging()) {
				return events;
				}
			}
*/			
		}
		
		for (int i = 0; i < events.length; i++)
		{
			if (events[i] != null) {
								
				try {
					// Write CBE to logging agent
					cbelogger.write(EventFormatter.toCanonicalXMLString(events[i],false));
				} catch (Exception ioe) {					

				    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();

				    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
				    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID(),getAgentName()});							    

				    event.setSeverity(CommonBaseEvent.SEVERITY_FATAL);
					
				    log(event);
				}
			}
		}
		return events;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#testProcessEventItems(java.lang.Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs)
		throws AdapterInvalidConfig {
			if(!(msgs instanceof CommonBaseEvent[])) {
				throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
			}
			return testProcessCBEs((CommonBaseEvent[]) msgs);
		}
		
	private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events)
		{
			return events;
		}


	/**
	 * update the configuration based on the configuration Element
	 */
	public void update() throws AdapterInvalidConfig {
		
		// first get the basic configuration set
		super.update();
		
		// Get configuration
		
		Element element = getConfiguration();
		
		Element outputterTypeInstance = null;
		Element outputterNode;
		
		String waittm = null;
		String agent = null;

		// Get the outputter parameters from the outputter properties
		Hashtable outputterProperties = getProperties();		
		if (outputterProperties != null && !outputterProperties.isEmpty()) {
			waittm = (String)outputterProperties.get(Messages.getString("HyadesGAwaitTimeAttributeName"));
			if (waittm != null && waittm.length() > 0) {
				setWaitTime(Long.valueOf(waittm).longValue());
			}

			setAgentName((String)outputterProperties.get(Messages.getString("HyadesGAagentNameAttributeName")));
		}
		else {		
			/**
			 * If there are no properties then get the outputter parameters from the old LogOutputterType instance
			 */
			NodeList outputterNodes = element.getChildNodes();
			for (int i = 0; i < outputterNodes.getLength(); i++) {
				if (outputterNodes.item(i).getNodeType() == Node.ELEMENT_NODE) {
					outputterNode = (Element) outputterNodes.item(i);
	
					if (outputterNode.getTagName().equals(Messages.getString("HyadesGALogOutputterTypeTagName"))) {
						// Get the outputter parameters from the outputter type instance attributes
						outputterTypeInstance = outputterNode;
						// Get attributes		
						if (outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) {
							String wtime = outputterTypeInstance.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"));
							if (wtime != null && !wtime.equals("")) {
								setWaitTime(Long.valueOf(wtime).longValue());
							}
						}									
						if (outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName")))
							setAgentName(outputterTypeInstance.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));
					}
				}
			}		
		}
		
		// Create the logging agent
		if (cbelogger == null) {
			String logAgentName;
			if (getAgentName() == null) {
				logAgentName = defaultAgentName;
			}
			else {
				logAgentName = getAgentName();
			}
			cbelogger = new LoggingAgent(logAgentName);
		}

	}

	/**
	 * Sets the agent name
	 * @param aName The agent name to set
	 */

	public void setAgentName(String aName) {
		agentName = aName;
	}

	/**
	 * Gets the agent name
	 * @return String
	 */

	public String getAgentName() {
		return agentName;
	}

	/**
	 * Sets the wait time.
	 * @param wTime The wait time to set
	 */

	public void setWaitTime(long wTime) {
		waitTime = wTime;
	}

	/**
	 * @return
	 */
	/**
	 * Gets the wait time.
	 * @return long
	 */

	public long getWaitTime() {
		return waitTime;
	}

	public void stop() {
		cbelogger.deregister();
	}
}
