/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;

/**
 * @author rduggan
 *
 * A parser preparation exception.
 * 
 */ 
public class PreparationException extends AdapterInvalidConfig {

	private String details = null;
	private String digraph;
	private String message;
	
	
	/**
	 * 
	 */
	public PreparationException() {
		super();
	}

	/**
	 * @param message
	 */
	public PreparationException(String message) {
		super(message);
		this.message=message;
	}

	/**
	 * @param message
	 * @param cause
	 */
	public PreparationException(String message, Throwable cause) {
		super(message, cause);
		this.message=message;
	}

	/**
	 * @param cause
	 */
	public PreparationException(Throwable cause) {
		super(cause);
	}
	
	public String getDetails() {
		return details;
	}
	
	public void setDetails(String details) {
		this.details=details;
	}
	
	public String getDigraph() {
		return digraph;
	}
	
	public void setDigraph(String graph) {
		this.digraph=graph;
	}
	
	public String getMessage() {
		return message;
	}
	
	

}
