/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.util;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;

/**
 * An adapter configuration migration exception
 * 
 */
public class AdapterMigrationException extends AdapterInvalidConfig {

	private String details = null;
	private String elementName;
	private String attributeName;
	/**
	 * 
	 */
	public AdapterMigrationException() {
		super();
	}

	/**
	 * @param message
	 */
	public AdapterMigrationException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public AdapterMigrationException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public AdapterMigrationException(Throwable cause) {
		super(cause);
	}
	
	public String getDetails() {
		return details;
	}
	
	public void setDetails(String details) {
		this.details=details;
	}
	
	public String getElementName() {
		return elementName;
	}
	
	public void setElementName(String name) {
		elementName=name;
	}
	
	

	/**
	 * @return
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * @param string
	 */
	public void setAttributeName(String string) {
		attributeName = string;
	}

}
