/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.dialog;

import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;


/**
 * 
 */
public class EObjectResourceLabelProvider extends LabelProvider
{
	private Hashtable ovelayCache;
	private boolean useImages;
	private Image image;

	/**
	 * Constructor for PerspectiveLabelProvider
	 */
	public EObjectResourceLabelProvider(boolean useImages, Image image)
	{
		super();
		this.useImages = useImages;
		this.image = image;
		ovelayCache = new Hashtable();
	}

	/**
	 * @see LabelProvider#getImage(Object)
	 */
	public Image getImage(Object element)
	{
		if((!useImages) || (element == null))
			return null;

		if(this.image != null)
			return image;

		if (element instanceof IAdaptable)
		{
			IWorkbenchAdapter adapter =
				(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

			if(adapter != null)
				return adapter.getImageDescriptor(element).createImage();
		}

		return null;			
	}

	/**
	 * @see LabelProvider#getText(Object)
	 */
	public String getText(Object element)
	{
		if(element == null)
			return ""; //$NON-NLS-1$

		String text = null;
	
		if(element instanceof EObject)
		{
			IFile file = EMFUtil.getWorkspaceFile((EObject)element);
			text = file.getName();
		}			
		else if(element instanceof IAdaptable)
		{
			IWorkbenchAdapter adapter =
				(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

			if(adapter != null)
				text = adapter.getLabel(element);
		}

		if(text == null)
			text = element.toString();
		
		return text;		
	}
	

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose()
	{
		if(ovelayCache != null)
		{
			for(Iterator i = ovelayCache.values().iterator(); i.hasNext();)
			{
				Image image = (Image)i.next();
				image.dispose();
			}
			ovelayCache.clear();
		}
	
		super.dispose();
	}
}