/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.VolatileTypes;
import org.eclipse.hyades.test.ui.navigator.TestSuiteVolatileProxy;

/**
 * 
 * @author jgout
 */
public class TestSuiteHTNConverter implements IHyadesTestNavigatorConverter {
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter#getObjectFromResource(org.eclipse.core.resources.IResource)
	 */
	public Object getObjectFromResource(IResource file) {
		//- returns the first TPFTestSuite found in the EMF file
		String ext = file.getFileExtension();
		if (ext!=null && ext.equals(ICommonConstants.TEST_SUITE_FILE_EXTENSION)) {
			//- get the info of the given file
			URI uri = VolatileTypes.getInstance().getVolatileElementInfo((IFile)file).getURI();
			if(uri != null) {
				//- this test suite file is volatile, convert first TPFTestSuite into a proxy and return it
				TestSuiteVolatileProxy tsProxy  = new TestSuiteVolatileProxy(uri, (IFile)file);
				return tsProxy;
			} else {
				//- not a volatile test suite file, return the test suire as is
				EObject[] eObjects = EMFUtil.load(null,(IFile) file);
				//- get the first TPFTestSuite
				TPFTest ts = null;
				for (int i = 0; i < eObjects.length; i++) {
					if (eObjects[i] instanceof TPFTestSuite) {
						return (TPFTestSuite)eObjects[i];
					}
				}
				return null;
			}
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement, java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
	}

}
