/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.processes.TestExecutionProcess;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

public class StopAction 
extends Action implements IDisposable
{
	private IStructuredSelection structuredSelection;
	private TestExecutionProcess executionProcess;

	public StopAction()
	{
		super(TestUIPlugin.getString("STOP_TEXT")); //$NON-NLS-1$
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.STOP_ACT);												
		
	}
	
	public void dispose()
	{
		structuredSelection = null;
	}

	protected IStructuredSelection getStructuredSelection()
	{
		return structuredSelection;
	}
	
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		this.structuredSelection = structuredSelection;
	}

	private boolean isSameObject(EObject obj1, EObject obj2) {
		URI uri1 = obj1 != null ? EcoreUtil.getURI(obj1) : null;
		URI uri2 = obj2 != null ? EcoreUtil.getURI(obj2) : null;
		return uri1 != null && uri1.equals(uri2);
	}
	
	private TestExecutionProcess getExecutionProcess(TPFExecutionResult execResult) {
		ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
		for (int i = 0; i < launches.length; i++) {
			IProcess[] processes = launches[i].getProcesses();
			for (int j = 0; j < processes.length; j++) {
				if (processes[j] instanceof TestExecutionProcess) {
					TestExecutionProcess process = (TestExecutionProcess) processes[j];				
					if (isSameObject(execResult, process.getExecutionResult())) {
						return process;
					}
				}
			}
		}
		return null;
	}
	
	public void run()
	{
		IStructuredSelection selection = getStructuredSelection();
		
		if(selection != null && !selection.isEmpty())
		{
			Object object = selection.getFirstElement();
			if(object instanceof TPFExecutionResult)
			{
				TPFExecutionResult execResult = (TPFExecutionResult) object;
				
				if (this.executionProcess != null) {
					try {
						this.executionProcess.terminate();
					} catch (DebugException e) {
						TPFDeployment deployment = execResult.getDeployment();
						String errMsg = TestUIPlugin.getString("STOP_FAIL_TEXT"); //$NON-NLS-1$
						errMsg = StringUtil.replace(errMsg, "%1", deployment.getName()); //$NON-NLS-1$
						IStatus err1 = e.getStatus();
						ErrorDialog.openError(null, TestUIPlugin.getString("TEST_ERR_MSG"), errMsg, err1); //$NON-NLS-1$	
					}
				}
			}
		}
		structuredSelection = null;
	}

	public boolean isApplicableForSelection()
	{
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		if(selection instanceof TPFExecutionResult)
		{
			return true;
		}
		return false;
	}
	
	public boolean isApplicableForEnablement(){
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		if(selection instanceof TPFExecutionResult)
		{
			TPFExecutionResult execResult = (TPFExecutionResult) selection;
			TPFExecutionHistory execHistory = execResult.getExecutionHistory();
			EList execEvents = execHistory.getExecutionEvents();
			if (execEvents.size() > 0){
				Object obj = execEvents.get(execEvents.size()-1);
				if (obj instanceof TPFTypedEvent){
					TPFTypedEvent execEvent = (TPFTypedEvent) obj;
					TPFExecutionType type = execEvent.getType();
					if (type.getValue() == TPFExecutionType.STOP){
						return false;
					}
				}
			} 
			this.executionProcess = getExecutionProcess((TPFExecutionResult)selection);
			if (this.executionProcess != null && !this.executionProcess.isTerminated()) {
				return true;
			} else {
				return false;
			}
		}
		return false;
	}
	
}
