/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.util.LocationUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.PartInitException;

/**
 * Extends the HyadesNewWizard to create the Hyades Generic Location.
 * 
 * @author psun
 * @since 0.0.1
 * @author bjiang
 * @since 1.3
 */
public class LocationNewWizard extends HyadesNewWizard {
	
	private CFGMachineConstraint newLocation;

	/**
	 * Constructor for LocationNewWizard
	 */
	public LocationNewWizard()
	{
		super();
		setWindowTitle(TestUIPlugin.getString("WIZ_LOCATION_TTL")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWLOCATION));

		IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("LocationNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("LocationNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the datapool created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_LOCATION_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.LOCATION_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_TTL")); //$NON-NLS-1$
		getLocationPage().setDescription(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_LOC_DSC")); //$NON-NLS-1$
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_TTL")); //$NON-NLS-1$
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_ATT_DSC")); //$NON-NLS-1$
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		String hostname = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.DEFAULT_HOST_NAME);
		LocationUtil.createNew(file, getAttributeWizardPage().getItemName(), getAttributeWizardPage().getItemDescription(), hostname);
		return true;
	}
		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		LocationUtil.openEditor(file);
	}	

	public CFGLocation getNewLocation()
	{
		return this.newLocation;
	}
}
