/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * This interface is used for the launchConfigValidator extension point.
 * The method validate() is invoked from any Launch Configuration that contains
 * the Test or TestComponent tab, to diagnose whether the configuration has errors
 * or warnings.
 * @author jcanches
 */
public interface ITestLaunchConfigurationValidator {
	
	public interface Diagnostic {
		public final static int ERROR = 0;
		public final static int WARNING = 1;
		String getMessage();
		int getSeverity();
	}
	
	/**
	 * Return a diagnostic if the Launch Configuration has problems.
	 * Return null if there are no problems with the Launch Configuration.
	 * @param launchConfiguration
	 * @return
	 */
	Diagnostic validate(ILaunchConfiguration launchConfiguration);
	
}
