/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Test Java plugin.
 *  
 * @author marcelop
 * @since 1.0.2
 */
public class TestCommonImages
extends ImageManager
{
	/**
	 * TestCommonImages' singleton.
	 */
	public static final TestCommonImages INSTANCE = new TestCommonImages();
	
	/*
	 * Available cached Images in the Common plugin image registry.
	 */
	public static final String IMG_WIZBAN_GENERATE   	        = "generate_wiz.gif";
	
	public static final String IMG_LOOP	 				    	= "loop.gif";
	public static final String IMG_INVOCATION			    	= "invocation.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_GENERATE);

		add(T_OBJ, IMG_LOOP);
		add(T_OBJ, IMG_INVOCATION);
	}	
}
