/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.internal.util;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonPlugin;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestCommonUtil
{
	/**
	 * Returns a unique name based on the specified base and list of INamedElement.
	 * @param baseName
	 * @param namedElementList
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList)
	{
		if(namedElementList == null)
			return baseName;
			
		return getUniqueName(baseName, namedElementList, namedElementList.size()+1);
	}

	/**
	 * Returns a unique name based on the specified base and list of INamedElement.
	 * If the element class parameter is different than null then the initial 
	 * number to be appended to the base name is equals to the number of instaces
	 * of this class in the list.    
	 * @param baseName
	 * @param namedElementList
	 * @param elementClass 
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList, Class elementClass)
	{
		if(elementClass == null)
			return getUniqueName(baseName, namedElementList);
			
		int count = 1;
		for(Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			if(elementClass.isInstance(i.next()))
				count++;
		}
		
		return getUniqueName(baseName, namedElementList, count);
	}

	/**
	 * Returns a unique name based on the specified base and list of INamedElement.  The
	 * initial number parameter is appended to the base name.
	 * @param baseName
	 * @param namedElementList
	 * @param initialNumber
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList, int initialNumber)
	{
		if(namedElementList == null)
			return baseName;

		String[] args = new String[]{baseName, Integer.toString(initialNumber)};
		String name = TestCommonPlugin.getString("NME_CONCAT", args);

		for (Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			INamedElement namedElement = (INamedElement)i.next();
			if(name.equals(namedElement.getName()))
			{
				args[1] = Integer.toString(++initialNumber);
				name = TestCommonPlugin.getString("NME_CONCAT", args);
				i = namedElementList.iterator();
			}
		}
		
		return name;
	}
	
	public static ITestCase createTestCase(ITestSuite testSuite, String type, boolean externalBehavior, String name)
	{
		ITestCase testCase = HyadesFactory.INSTANCE.createTestCase();
		((EObject)testCase).eAdapters().add(new TestCaseUniqueNameAdapter());
		testCase.setName(name);
		testCase.setType(type);
		
		testSuite.getITestCases().add(testCase);
		HyadesFactory.INSTANCE.createImplementor(testCase, externalBehavior);
		
		return testCase;
	}
}
