/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLDescriptorLoader extends IgnoredXMLFragmentLoader {
	protected String fId;
	protected String fParent;
	protected StringBuffer fDescription = new StringBuffer();
	protected String fName;
	protected static final String id = "id";
	protected static final String parent = "parent";
	protected static final String name = "name";
	protected static final String description = "description";

	protected int localDepth;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fId = null;
		fParent = null;
		fName = null;
		fDescription.setLength(0);
		localDepth = 0;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case StatisticalConstants.id_int :
				fId = value;
				break;
			case StatisticalConstants.parent_int :
				fParent = value;
				break;
			case StatisticalConstants.name_int :
				fName = value;
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#startChild(java.lang.String)
	 */
	public void startChild(String name) {
		if (localDepth == 0 && name.equals(description)) {
			localDepth++;
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#endChild(java.lang.String)
	 */
	public void endChild(String name) {
		if (localDepth == 1 && name.equals(description)) {
			localDepth--;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addCharacters(char[], int, int)
	 */
	public void addCharacters(char[] data, int offset, int length) {
		if (localDepth == 1) {
			fDescription.append(data, offset, length);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		SDDescriptor descriptor = (SDDescriptor) LookupServiceExtensions.getInstance().locate(context, SDDescriptor.class, fId);
		if (descriptor == null) {
			descriptor = StatisticalFactory.eINSTANCE.createSDDescriptor();
			descriptor.setId(fId);
		}
		updateAttributes(descriptor);

	}
	protected void updateAttributes(SDDescriptor descriptor) {
		descriptor.setName(fName);
		descriptor.setDescription(fDescription.toString());
		if (fParent != null && descriptor.getParent() == null) {
			SDDescriptor parentDescriptor = (SDDescriptor) LookupServiceExtensions.getInstance().locate(context, SDDescriptor.class, fParent);
			if(parentDescriptor!=null)
				descriptor.setParent(parentDescriptor);
			else
				LoadersUtils.getOrCreateAgent(context).getDescriptor().add(descriptor);
		}
		else
			LoadersUtils.getOrCreateAgent(context).getDescriptor().add(descriptor);
		
	}
}
