/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import java.util.Iterator;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLTextObservationLoader extends SnapshotObservationBase {
	protected String fValue;
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fValue = null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (name.equals("value")) {
			fValue = value;
		} else
			super.addAttribute(name, value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#updateAttributes(org.eclipse.hyades.model.statistical.SDSnapshotObservation)
	 */
	protected void updateAttributes(SDTextObservation observation) {
		super.updateAttributes(observation);
		observation.getTextValue().add(fValue);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		super.addYourselfInContext();
		if(mMemberDescriptor==null)
			return;
		SDTextObservation observation = findTextObservation(mMemberDescriptor);
		if(observation==null)
		{
			observation = StatisticalFactory.eINSTANCE.createSDTextObservation();
			mMemberDescriptor.getSnapshotObservation().add(observation);
		}
		updateAttributes(observation);
	}

	/**
	 * @param memberDescriptor
	 * @return
	 */
	private SDTextObservation findTextObservation(SDMemberDescriptor descriptor) {
		for (Iterator iter = descriptor.getSnapshotObservation().iterator(); iter.hasNext();) {
			SDSnapshotObservation element = (SDSnapshotObservation) iter.next();
			
			//TODO: MS add support for multiple windows/views
			if(element instanceof SDTextObservation)
				return (SDTextObservation)element;
		}
		return null;
	}
	
}
