/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SD Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This is the base class for all the desciptors on the model. This class provides the ability to structure the descriptor data in a tree (parent/child relationship).  
 * 
 * This class, and its subclasses, does not hold any data fields proper, but rather contain all the metadata that describe the counters, statistics, etc. that can be collected from an agent instance. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDDescriptor#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDDescriptor#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDDescriptor#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDDescriptor#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDDescriptor#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor()
 * @model 
 * @generated
 */
public interface SDDescriptor extends AbstractTRCDescription{
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor_Id()
	 * @model 
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor_Description()
	 * @model 
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Children</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.model.statistical.SDDescriptor}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Children</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' containment reference list.
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor_Children()
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getParent
	 * @model type="org.eclipse.hyades.model.statistical.SDDescriptor" opposite="parent" containment="true"
	 * @generated
	 */
	EList getChildren();

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' container reference.
	 * @see #setParent(SDDescriptor)
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDDescriptor_Parent()
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getChildren
	 * @model opposite="children"
	 * @generated
	 */
	SDDescriptor getParent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getParent <em>Parent</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' container reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(SDDescriptor value);

} // SDDescriptor
