/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace;

import org.eclipse.hyades.collection.correlation.BaseApplicationImpl;
import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;


/**
 * This is the application to collect the trace data.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class IiopProfiler extends BaseApplicationImpl {

	public static final int VERSION = 1;
	public static final int ID = 10002;
    private static IiopProfiler instance = null;
    private TraceLogger agent;


    /**
     * This creates a singleton profiler.
     */
    public static IiopProfiler getInstance() {
        
        synchronized (IiopProfiler.class) {
            return (instance == null ? instance = new IiopProfiler() : instance);
        }
    }

    
    /**
     * This is the default constructor.
     */
    private IiopProfiler() {
        
        agent = TraceLogger.getInstance();
    }
    

	/**
	 * @see org.eclipse.hyades.collection.correlation.BaseApplicationImpl#instantiateCorrelator()
	 */
	public BaseCorrelatorDataImpl instantiateCorrelator() {
		return new TraceCorrelator();
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IApplication#getId()
	 */
	public int getId() {
		return ID;
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IApplication#getVersion()
	 */
	public int getVersion() {
		return VERSION;
	}
}
