/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for an agent creation.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordAgentCreate {

    private final String agentId;
    private final String processIdRef;
    private final String nodeIdRef;
    private final String agentName;
    private final String time;
    private String agent_parameters = null;
    private String version = null;


    /**
     * Creates a record for an agent.
     * 
     * @param agentId   the UUID of the agent
     * @param processId the UUID of the process in which the agent was created
     * @param nodeId    the UUID of the node in which the agent was created
     * @param agentName the name of the agent
     * @param time      the time at which the agent was created
     */
    public RecordAgentCreate(String agentId, String processIdRef, String nodeIdRef,
        String agentName, String time) {

        this.agentId = agentId;
        this.processIdRef = processIdRef;
        this.nodeIdRef = nodeIdRef;
        this.agentName = agentName;
        this.time = time;
    }


    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string
     */
    public String toString() {

        return "<agentCreate agentId=\"" + agentId + "\" processIdRef=\"" + processIdRef +
            "\" nodeIdRef=\"" + nodeIdRef + "\" agentName=\"" + agentName + "\" time=\"" + time + "\"" +
            (agent_parameters == null ? "" : " agent_parameters=\"" + agent_parameters + "\"") +
            (version == null ? "" : " version=\"" + version + "\"") + "/>";
    }


    public String getAgentId() {
        return agentId;
    }


    public String getAgent_parameters() {
        return agent_parameters;
    }


    public String getAgentName() {
        return agentName;
    }


    public String getProcessIdRef() {
        return processIdRef;
    }


    public String getTime() {
        return time;
    }


    public String getVersion() {
        return version;
    }


    public void setAgent_parameters(String agent_parameters) {
        this.agent_parameters = agent_parameters;
    }


    public void setVersion(String version) {
        this.version = version;
    }
}
