/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 *
 * A IOrderedProperty is a property that may have many ordered values.
 * @version 0.0.2
 */
public interface IOrderedProperty extends Cloneable {

	/**
	 * Sets the name of the property
	 * @param name The name of the property
	 */
	public void setName(String name);

	/**
	 * Gets the name of the property
	 * @return The name of the property
	 */
	public String getName();

	/**
	 * Appends a value to a property's value list.
	 * @param value The value to append
	 */
	public void appendValue(Object value);

	/**
	 * Prepend a value to a property's value list.
	 * @param value The value to prepend
	 */
	public void prependValue(Object value);

	/**
	 * Retrieve the ordered list of values.
	 * @return Object[] the current value(s).
	 */
	public Object[] getValues();

	/**
	 * Clears a propery.
	 * @return Object[] the previously set value(s).
	 */
	public Object[] clear();


}
