/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.internal.collection.framework;

import java.net.Socket;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import org.eclipse.hyades.execution.security.*;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ClientHandlerImpl implements IClientHandler {
	
	private Socket _socket;
	
	private InputStream _instrm;
	
	private OutputStream _outstrm;

	public ClientHandlerImpl(Socket s) {
		_socket = s;
		
		try {
			_instrm = s.getInputStream();
		
			_outstrm = s.getOutputStream();
		}
		catch (IOException ioe) {
			_instrm = null;
			_outstrm = null;
		}
	}
	
	public byte[] getRemoteAddress() {
		return _socket.getInetAddress().getAddress();
	}

	public int read(byte[] b, int off, int len) {
		int bytesRead;
		
		try {
			bytesRead = _instrm.read(b, off,len);
		}
		catch (IOException ioe) {
			bytesRead = -1;
		}
			
		return bytesRead;
	}
	
	public int write(byte[] b, int off, int len) {
		try {
			_outstrm.write(b, off, len);
		}
		catch (IOException ioe) {
			return -1;
		}
		
		return 0;
		
	}
	
	public void closeConnection() {
		try {
			_instrm.close();
			_outstrm.close();
		
			_socket.close();
		}
		catch (IOException ioe) {
		}
	}
}