/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import org.w3c.dom.Element;

public class Variable extends ConfigElement {
	public final static String TAG = ConfigUtility.getString("Config.Variable.Tag");

	public static void setName(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"), value);
	}

	public static String getName(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"));
	}

	public static void setValue(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"), value);
	}

	public static String getValue(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"));
	}

	public static void setPosition(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"), value);
	}

	public static String getPosition(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"));
	}

}
