/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.collection.framework;

/**
 *
 * Description:
 * 		Describes a data channel Flusher process.
 *
 * Parameters
 * 		name of Data Channel
 * 		(optional) name of file to flush the data in the data channel to
 * 				- default file name is c:\temp\dctest.out
 *
 * Creation date: Apr 10, 2003
 *
 */

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

/** Represents a data channel flusher process. */
public class DCFlusherProcess {

    // File name (shared between ctor and run)
    private static String fileName;
    private static String DCName;

    /** The entry point. Control is passed to run(). */
    public static void main(String[] args) {
        DCFlusherProcess theReader = new DCFlusherProcess(args);

        DataChannelHelper dch = new DataChannelHelper();

        DataChannelImpl dc;

		/* This flusher process reads data from the data channel and writes it
		 * to a file.
		 */
        try {
        	dc = dch.createDataChannel(DCName);
        	
        	dc.setFlushable();

        	FileOutputStream fstream = new FileOutputStream(fileName);
        	
        	InputStream istrm = dc.getInputStream();

			byte[] inbytes = new byte[8096];
			int bytesRead = 0;
			
			/* Read from the intput stream returned by the data channel
			 * and write to the file stream.
			 */		
			try {
				while (true) {
					bytesRead = istrm.read(inbytes);
			
					if (bytesRead > 0) {
						fstream.write(inbytes, 0, bytesRead);
					
					}
					else if (bytesRead < 0) {
						// End of File reached - no more data to read so quit
						break;	
					}
				}
				istrm.close();	
			}
			catch (IOException ioe) {
				System.out.println("IOException occurred tyring to read from file or write to data channe");
			}

			fstream.close();
        	
        }
        catch (DataChannelCreationException e) {
        	System.out.println("DCFlusherProcess:  could not create data channel with name " + DCName
        	     + "\n   Reason: " + e.getMessage());
        }
        catch (InvalidDataChannelAccessException e) {
         	System.out.println("DCFlusherProcess:  Cannot read from this data channel");
        }       	
        catch (DataChannelNotInitializedException e) {
         	System.out.println("DCFlusherProcess:  data channel is not initialized");
        }
        catch (FileNotFoundException e) {
         	System.out.println("DCFlusherProcess:  could not open file " + fileName);
        }
        catch (IOException e) {
         	System.out.println("DCFlusherProcess:  could not close file " + fileName);
        }
    }

	public DCFlusherProcess(String[] args) {
		System.out.println("DCFlusherProcess: Command line arguments, length="+args.length);
        for ( int i=0; i<args.length; i++ )
            System.out.println("\targs["+i+"] = "+args[i]);

        // Data Channel name is the first command line argument, file name is the second
        if (args.length == 2) {
           DCName = args[0];
           fileName = args[1];
        }
        else if (args.length == 1) {
        	DCName = args[0];
			fileName = "c:\\temp\\dctest.out";
        }
        else {
			DCName="shmchannel";
			fileName = "c:\\temp\\dctest.out";
        }
    }


}