/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParser_a118_20010215a
extends DumpParser {
    public void parse(DumpData d) throws Exception {
        DumpParser_a118_20010215a.logDebug(TAUtils.getNLSValue("ta.msg.ParsingDumpOutputFor.a118", "parsing dumpthreads output for build compatible with a118-20010215a"));
        try {
            if (this._r.ready()) {
                String s = this._r.readLine();
                this.getThreadData(d);
                this.getMonitors(d);
            }
        }
        catch (Exception e) {
            DumpParser_a118_20010215a.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + _dumpInName);
            throw new TaException("" + this._lineNo, e);
        }
    }

    private void getThreadData(DumpData d) throws Exception {
        String line = null;
        boolean firstChar = false;
        line = this.getLine(d);
        Object thd = null;
        while (this._r.ready() && line.indexOf("Full thread dump:") == -1) {
            DumpParser_a118_20010215a.logDebug(line);
            line = this.getLine(d);
        }
        String tid = null;
        String thdName = null;
        String state = null;
        while (this._r.ready() && line.indexOf("System Monitor Status") == -1) {
            int idx1 = 0;
            idx1 = line.indexOf("\"");
            if (idx1 > -1) {
                int idx2 = line.lastIndexOf("\"");
                thdName = line.substring(idx1 + 1, idx2);
                idx1 = line.indexOf("TID:");
                idx2 = line.indexOf(",");
                tid = line.substring(idx1 + 4, idx2);
                line = this.getLine(d);
                state = null;
                state = line.endsWith("MONITOR WAIT") ? "MW" : (line.endsWith("SUSPENDED") ? "S" : (line.endsWith("RUNNING") ? "R" : (line.endsWith("WAIT") ? "CW" : "?")));
                while (this._r.ready() && line.indexOf("------ Java stack ------") == -1) {
                    line = this.getLine(d);
                }
                String prio = "?";
                idx1 = line.indexOf("prio=");
                if (idx1 > -1) {
                    idx2 = line.substring(idx1).indexOf(" ");
                    prio = idx2 > -1 ? line.substring(5, idx2) : line.substring(idx1 + 5);
                }
                DumpParser_a118_20010215a.logDebug(thdName + " (" + tid + ") " + state + "  " + prio);
                Thd t = d.addThd(thdName, tid, state, prio);
                line = this.getLine(d);
                while (this._r.ready() && !line.startsWith("--")) {
                    String fqMethod = line.substring(0, line.indexOf("("));
                    fqMethod = fqMethod.trim();
                    String moduleInfo = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"));
                    String pkg = fqMethod.substring(0, fqMethod.lastIndexOf(46));
                    String method = fqMethod.substring(fqMethod.lastIndexOf(46) + 1);
                    String module = null;
                    String sLineNo = null;
                    int lineNo = -1;
                    int idx = moduleInfo.indexOf(58);
                    if (idx != -1) {
                        module = moduleInfo.substring(0, idx);
                        sLineNo = moduleInfo.substring(idx + 1);
                    } else if (!moduleInfo.equals("compiled code")) {
                        module = moduleInfo;
                    }
                    if (sLineNo != null) {
                        lineNo = Integer.parseInt(sLineNo);
                    }
                    DumpParser_a118_20010215a.logDebug("\t" + pkg + " . " + method + " --" + module + "%" + lineNo + "*" + moduleInfo);
                    StkEntry se = new StkEntry(method, pkg, module, lineNo, false);
                    t.addStackEntry(se);
                    line = this.getLine(d);
                    DumpParser_a118_20010215a.logDebug(line);
                }
            }
            line = this.getLine(d);
        }
        DumpParser_a118_20010215a.logDebug(line);
    }

    private void getMonitors(DumpData d) throws Exception {
        String line = this.getLine(d);
        while (this._r.ready() && line.indexOf("Object Monitor Status") == -1) {
            DumpParser_a118_20010215a.logDebug(line);
            line = this.getLine(d);
        }
        line = this.getLine(d);
        Monitor m = null;
        line = this.getLine(d);
        while (this._r.ready() && line.length() > 0) {
            if (line.charAt(0) != '\t') {
                DumpParser_a118_20010215a.logDebug(line);
                String monName = line.substring(0, line.indexOf(58));
                monName = monName.trim();
                DumpParser_a118_20010215a.logDebug(TAUtils.getNLSValue("ta.string.monitor", "monitor") + " - " + monName);
                m = d.addMonitor(monName, 1);
            } else {
                DumpParser_a118_20010215a.logDebug(TAUtils.getNLSValue("ta.string.waiter", "waiter") + " - " + line);
                String tid = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
                Thd t = d.getThd(tid);
                m.addWaiter(t);
            }
            line = this.getLine(d);
        }
    }
}

