/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.local.SessionContext;

public final class SessionContextToSessionMap {
    private static final SessionContextToSessionMap singleton = new SessionContextToSessionMap();
    private Hashtable sessionFromContext = new Hashtable();

    public static void addSession(SessionContext context, ISession session) {
        SessionContextToSessionMap.getInstance().addSessionEntry(context, session);
    }

    public static SessionContextToSessionMap getInstance() {
        return singleton;
    }

    public static ISession getSession(SessionContext context) {
        return SessionContextToSessionMap.getInstance().getSessionEntry(context);
    }

    public static boolean removeSession(ISession session) {
        return SessionContextToSessionMap.getInstance().removeSessionEntry(session);
    }

    public static void removeSession(SessionContext context) {
        SessionContextToSessionMap.getInstance().removeSessionEntry(context);
    }

    private SessionContextToSessionMap() {
    }

    public synchronized void addSessionEntry(SessionContext context, ISession session) {
        this.sessionFromContext.put(context, session);
    }

    public synchronized ISession getSessionEntry(SessionContext context) {
        return (ISession)this.sessionFromContext.get(context);
    }

    public synchronized boolean removeSessionEntry(ISession session) {
        Enumeration enumeration = this.sessionFromContext.keys();
        SessionContext context = null;
        while (enumeration.hasMoreElements()) {
            context = (SessionContext)enumeration.nextElement();
            ISession value = this.getSessionEntry(context);
            if (value == null || !value.equals(session)) continue;
            this.removeSessionEntry(context);
            break;
        }
        return false;
    }

    public synchronized void removeSessionEntry(SessionContext context) {
        this.sessionFromContext.remove(context);
    }
}

