/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;

public class Console
extends Thread
implements Constants {
    protected ServerSocket _sock = null;
    protected DataProcessor _processor = null;
    protected long _ip = 0L;
    protected long _port = 0L;
    private boolean _started = false;
    private boolean _valid = true;
    private Socket _activeConnection = null;

    public Console() {
        this.setName("Console");
        this.setDaemon(true);
    }

    public Console(String name) {
        super(name);
        this.setDaemon(true);
    }

    public Console(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
    }

    public long getIP() throws ConsoleNotStartedException {
        if (this._ip == 0L) {
            throw new ConsoleNotStartedException();
        }
        return this._ip;
    }

    public long getPort() throws ConsoleNotStartedException {
        if (this._port == 0L) {
            throw new ConsoleNotStartedException();
        }
        return this._port;
    }

    public ServerSocket getServerSocket() throws ConsoleNotStartedException {
        if (this._sock == null) {
            throw new ConsoleNotStartedException();
        }
        return this._sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buffer = new byte[1024];
        int port = 0;
        boolean started = false;
        while (!started) {
            try {
                started = true;
                this._sock = new ServerSocket(port, 1);
            }
            catch (Exception e) {
                port = (short)(port + 1);
                started = false;
            }
        }
        this._port = this._sock.getLocalPort();
        try {
            byte[] bytes = InetAddress.getLocalHost().getAddress();
            this._ip = (long)(bytes[3] << 24 & 0xFF000000) | (long)(bytes[2] << 16 & 0xFF0000) | (long)(bytes[1] << 8 & 0xFF00) | (long)(bytes[0] & 0xFF);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Console e = this;
        synchronized (e) {
            this._started = true;
            this.notify();
        }
        while (this._valid) {
            boolean complete;
            InputStream is = null;
            this._activeConnection = null;
            try {
                this._activeConnection = this._sock.accept();
                is = this._activeConnection.getInputStream();
                this._activeConnection.setSoTimeout(1000);
                complete = false;
            }
            catch (Exception e2) {
                return;
            }
            while (!complete) {
                int length = 0;
                try {
                    length = is.read(buffer);
                }
                catch (InterruptedIOException e3) {
                    if (this._processor != null) {
                        this._processor.waitingForData();
                    }
                }
                catch (IOException e4) {
                    try {
                        this._activeConnection.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    complete = true;
                }
                if (length < 0) {
                    try {
                        this._activeConnection.close();
                    }
                    catch (IOException e5) {
                        // empty catch block
                    }
                    complete = true;
                } else if (length > 0 && this._processor != null) {
                    this._processor.incommingData(buffer, length, this._activeConnection.getInetAddress());
                }
                if (this._valid) continue;
                try {
                    this._activeConnection.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                complete = true;
            }
        }
    }

    public void setDataProcessor(DataProcessor processor) {
        this._processor = processor;
    }

    public DataProcessor getDataProcessor() {
        return this._processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Console console = this;
        synchronized (console) {
            this._valid = true;
            super.start();
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this._started);
        }
    }

    public void write(String data) {
        if (this._activeConnection != null) {
            try {
                this._activeConnection.getOutputStream().write(data.getBytes("UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        this._valid = false;
    }
}

