/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;
    private String pathSeparator = System.getProperty("file.separator");

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String directory = null;
        String fileName = null;
        String converterCmdAttribute = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable sensorProperties = this.getProperties();
        if (sensorProperties != null && !sensorProperties.isEmpty()) {
            directory = (String)sensorProperties.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            fileName = (String)sensorProperties.get(Messages.getString("HyadesGAfileNameAttributeName"));
            converterCmdAttribute = (String)sensorProperties.get(Messages.getString("HyadesGAconverterCmdAttributeName"));
            this.converterShell = (String)sensorProperties.get(Messages.getString("HyadesGAconverterShellAttributeName"));
        } else {
            NodeList sensorNodes = element.getChildNodes();
            for (int i = 0; i < sensorNodes.getLength(); ++i) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() != 1 || !(sensorNode = (Element)sensorNodes.item(i)).getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) continue;
                sensorTypeInstance = sensorNode;
                if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                    directory = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                }
                if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                    fileName = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                }
                if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"))) {
                    converterCmdAttribute = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
                }
                if (!sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) continue;
                this.converterShell = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
            }
        }
        if (converterCmdAttribute != null && (converterCmdAttribute = converterCmdAttribute.trim()).length() == 0) {
            converterCmdAttribute = null;
        }
        if (this.converterShell != null) {
            this.converterShell = this.converterShell.trim();
            if (this.converterShell.length() == 0) {
                this.converterShell = null;
            }
        }
        if (directory == null || directory.trim().length() == 0 || fileName == null || fileName.trim().length() == 0 || converterCmdAttribute == null && !new File(directory, fileName).canRead()) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory.trim());
        this.setFileName(fileName.trim());
        this.setConverterCommand(converterCmdAttribute);
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] lineArray = new String[2];
        lineArray[0] = "test string";
        return lineArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null && !this.flushingMode) {
            this.rawLogFileName = this.getDirectory().endsWith(this.pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + this.pathSeparator + this.getFileName();
            if (this.rawLogFileName != null) {
                try {
                    if (this.input == null) {
                        this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                    }
                    this.input.prepare();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    this.log(event);
                }
            }
        }
        if (this.input != null) {
            for (int i = 0; i < this.maximumBlocking; ++i) {
                try {
                    this.lastLine[i] = this.input.readLine();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    this.log(event);
                }
                if (this.lastLine[i] != null) continue;
                i = this.maximumBlocking;
                this.rawLogFileName = null;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)20);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final void setConverterCommand(String converterCmd) {
        this.converterCommand = converterCmd;
    }

    class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.reader.read() != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = SingleOSFileSensor.this.currentThreadLock;
            synchronized (object) {
                if (++SingleOSFileSensor.this.childThreadsDone == 2) {
                    SingleOSFileSensor.this.currentThreadLock.notify();
                }
            }
        }
    }

    private class BufferedPeriodicReader {
        private String filename = null;
        private String converter = null;
        private String shell = null;
        private RandomAccessFile currentFile = null;
        private File currentFileStat = null;
        private int initialBufferSize = 2048;
        long lastBookmark = 0L;
        long lastModified = 0L;
        long lastSize = 0L;
        byte[] historicInfo = null;
        private String EOL_CHARS = System.getProperty("line.separator");
        private char EOL_LAST_CHAR = (char)(System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? 21 : (int)this.EOL_CHARS.charAt(this.EOL_CHARS.length() - 1));

        public BufferedPeriodicReader(String newFilename) {
            this(newFilename, null, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter) {
            this(newFilename, converter, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter, String shell) {
            this.filename = newFilename;
            this.converter = converter;
            this.shell = shell;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepare() {
            if (this.converter != null && this.converter.length() > 0) {
                try {
                    Process converterProcess;
                    Object object = SingleOSFileSensor.this.currentThreadLock;
                    synchronized (object) {
                        SingleOSFileSensor.this.childThreadsDone = 0;
                        String platform = System.getProperty("os.name", null);
                        if (platform.startsWith("Windows")) {
                            converterProcess = Runtime.getRuntime().exec(this.converter);
                        } else if (platform.startsWith("AIX")) {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String[] cmdarr = new String[]{this.shell, this.converter};
                            converterProcess = Runtime.getRuntime().exec(cmdarr);
                        } else {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String converterCmd = this.shell + " " + this.converter;
                            converterProcess = Runtime.getRuntime().exec(converterCmd);
                        }
                        new ConverterOutputReader(converterProcess.getErrorStream()).start();
                        new ConverterOutputReader(converterProcess.getInputStream()).start();
                        try {
                            SingleOSFileSensor.this.currentThreadLock.wait(300000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    int exitValue = -1;
                    try {
                        exitValue = converterProcess.waitFor();
                    }
                    catch (InterruptedException i) {
                        converterProcess.destroy();
                    }
                    if (exitValue != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    CommonBaseEvent event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    SingleOSFileSensor.this.log(event);
                }
            }
            try {
                this.currentFileStat = new File(this.filename);
                if (this.currentFileStat.lastModified() > this.lastModified || this.currentFileStat.length() != this.lastSize) {
                    this.currentFile = new RandomAccessFile(this.filename, "r");
                    this.lastModified = this.currentFileStat.lastModified();
                    this.lastSize = this.currentFile.length();
                }
            }
            catch (Exception e) {
                this.currentFile = null;
            }
            if (this.lastBookmark != 0L && this.currentFile != null) {
                try {
                    long previousOffset = this.lastBookmark;
                    long currentOffset = this.currentFile.length();
                    long charactersToCompare = Math.min(Math.min((long)SingleOSFileSensor.this.confidenceBufferSize, previousOffset), currentOffset);
                    if (currentOffset >= previousOffset) {
                        int value;
                        boolean append = true;
                        int i = SingleOSFileSensor.this.fileFooterSize;
                        while ((long)i < charactersToCompare) {
                            this.currentFile.seek(previousOffset - 1L - (long)i);
                            value = this.currentFile.read();
                            if (this.historicInfo[i] != (byte)value) {
                                append = false;
                                break;
                            }
                            ++i;
                        }
                        if (append) {
                            this.currentFile.seek(previousOffset - (long)SingleOSFileSensor.this.fileFooterSize);
                            for (i = SingleOSFileSensor.this.fileFooterSize - 1; i >= 0 && this.historicInfo[i] == (byte)(value = this.currentFile.read()); --i) {
                            }
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                    }
                    long matchedChars = 0L;
                    int historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                    long currentCurrentFileOffset = currentOffset -= (long)SingleOSFileSensor.this.fileFooterSize;
                    do {
                        this.currentFile.seek(--currentCurrentFileOffset);
                        if (this.historicInfo[historicInfoOffset++] == this.currentFile.read()) {
                            ++matchedChars;
                            continue;
                        }
                        currentCurrentFileOffset = --currentOffset;
                        historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                        matchedChars = 0L;
                    } while (matchedChars < charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize && currentOffset > 0L);
                    if (matchedChars == charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize) {
                        this.currentFile.seek(currentOffset);
                        for (int i = SingleOSFileSensor.this.fileFooterSize - 1; i >= 0; --i) {
                            int value = this.currentFile.read();
                            if (this.historicInfo[i] == (byte)value) continue;
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                        this.historicInfo = null;
                        this.lastBookmark = currentOffset + (long)SingleOSFileSensor.this.fileFooterSize;
                        return;
                    }
                    this.historicInfo = null;
                    this.lastBookmark = 0L;
                    return;
                }
                catch (IOException e) {
                    CommonBaseEvent event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    SingleOSFileSensor.this.log(event);
                }
            }
        }

        public void close() {
            try {
                if (this.currentFile != null) {
                    this.currentFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentFile = null;
        }

        public String readLine() throws IOException {
            boolean endOfFile = false;
            if (this.currentFile != null) {
                String last = null;
                this.currentFile.seek(this.lastBookmark);
                if (this.currentFile != null) {
                    try {
                        byte[] buffer = new byte[this.initialBufferSize];
                        int bufferSize = 0;
                        int singleByte = 0;
                        while ((singleByte = this.currentFile.read()) != -1) {
                            if (singleByte == this.EOL_LAST_CHAR) {
                                if (this.EOL_CHARS.length() > 1 && bufferSize > 0) {
                                    for (int k = this.EOL_CHARS.length() - 2; k >= 0 && (byte)this.EOL_CHARS.charAt(k) == buffer[bufferSize - 1]; --k) {
                                        buffer[--bufferSize] = 0;
                                    }
                                    break;
                                }
                                if (bufferSize <= 0 || this.EOL_LAST_CHAR != '\n' || buffer[bufferSize - 1] != 13) break;
                                buffer[--bufferSize] = 0;
                                break;
                            }
                            if (bufferSize == buffer.length) {
                                byte[] tempBuffer = new byte[buffer.length + this.initialBufferSize];
                                System.arraycopy(buffer, 0, tempBuffer, 0, bufferSize);
                                buffer = tempBuffer;
                            }
                            buffer[bufferSize++] = (byte)singleByte;
                        }
                        if (singleByte == -1) {
                            endOfFile = true;
                        }
                        last = bufferSize == 0 && endOfFile ? null : new String(buffer, 0, bufferSize);
                    }
                    catch (EOFException e) {
                        last = null;
                    }
                    catch (NullPointerException e) {
                        last = null;
                    }
                    if (endOfFile) {
                        int bytesToSave = (int)Math.min(this.currentFile.length(), (long)SingleOSFileSensor.this.confidenceBufferSize);
                        this.currentFile.seek(this.currentFile.length() - (long)bytesToSave);
                        this.historicInfo = new byte[bytesToSave];
                        for (int i = bytesToSave - 1; i >= 0; --i) {
                            this.historicInfo[i] = (byte)this.currentFile.read();
                        }
                        this.close();
                    } else {
                        this.lastBookmark = this.currentFile.getFilePointer();
                    }
                    return last;
                }
            }
            return null;
        }
    }
}

