/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.Collection;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;

public class Arbiter {
    public VerdictEvent analyse(TestInvocation testInvocation) {
        VerdictEvent verdictEvent;
        if (testInvocation.getTest() instanceof TestCase) {
            return testInvocation.getVerdictEvent();
        }
        Collection collection = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
        TestSuite testSuite = (TestSuite)testInvocation.getTest();
        int n = 0;
        if (collection != null) {
            verdictEvent = collection.iterator();
            while (verdictEvent.hasNext()) {
                TestInvocation testInvocation2 = (TestInvocation)verdictEvent.next();
                if (!ModelUtil.isOwnerTestSuite(testSuite, testInvocation2) || testInvocation2.getVerdictEvent() == null) continue;
                int n2 = testInvocation2.getVerdictEvent().getVerdict();
                if (3 == n2) {
                    n = 3;
                    break;
                }
                if (2 == n2) {
                    n = 2;
                    continue;
                }
                if (0 == n2) {
                    if (-100 != n && 1 != n) continue;
                    n = 0;
                    continue;
                }
                if (1 != n2 || -100 != n) continue;
                n = 1;
            }
        }
        verdictEvent = ModelUtil.createTestVerdictEvent(testInvocation);
        verdictEvent.setVerdict(n);
        return verdictEvent;
    }

    public VerdictEvent analyse() {
        VerdictEvent verdictEvent;
        TestSuite testSuite = ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot();
        if (testSuite == null) {
            return null;
        }
        Collection collection = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
        int n = -100;
        if (collection != null) {
            verdictEvent = collection.iterator();
            while (verdictEvent.hasNext()) {
                TestInvocation testInvocation = (TestInvocation)verdictEvent.next();
                if (testInvocation.getVerdictEvent() == null) continue;
                int n2 = testInvocation.getVerdictEvent().getVerdict();
                if (3 == n2) {
                    n = 3;
                    break;
                }
                if (2 == n2) {
                    n = 2;
                    continue;
                }
                if (0 == n2) {
                    if (-100 != n && 1 != n) continue;
                    n = 0;
                    continue;
                }
                if (1 != n2 || -100 != n) continue;
                n = 1;
            }
        }
        if (n == -100) {
            n = 0;
        }
        verdictEvent = new VerdictEvent();
        verdictEvent.setOwnerId(ModelUtil.getHierarchyId(testSuite));
        verdictEvent.setVerdict(n);
        return verdictEvent;
    }
}

